/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.web;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Enums;
import com.voxeo.utils.HTTP;
import com.voxeo.utils.Props;
import com.voxeo.web.CacheMode;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class ExpiresFilter
implements Filter {
    private static final Loggerf log = Loggerf.getLogger(ExpiresFilter.class);
    private static final String CACHE_MODE_PARAM = "cacheMode";
    private static final String CACHE_MODE_SYSTEM = "com.voxeo.web.resourceFilter.cacheMode";
    private static final String CACHE_TIMEOUT_SECONDS_PARAM = "cacheTimeoutSeconds";
    private static final String CACHE_TIMEOUT_SECONDS_SYSTEM = "com.voxeo.web.resourceFilter.cacheTimeoutSeconds";
    private CacheMode cacheMode;
    private long cacheTimeoutMilli = 0L;

    public void init(FilterConfig config) throws ServletException {
        this.cacheMode = Enums.valueOf(CacheMode.class, System.getProperty(CACHE_MODE_SYSTEM, config.getInitParameter(CACHE_MODE_PARAM)), CacheMode.DEFAULT);
        switch (this.cacheMode) {
            case BASIC: {
                Long cacheTimeoutSeconds = Props.getLongSystemProperty(CACHE_TIMEOUT_SECONDS_SYSTEM, config.getInitParameter(CACHE_TIMEOUT_SECONDS_PARAM));
                if (cacheTimeoutSeconds == null) break;
                this.cacheTimeoutMilli = cacheTimeoutSeconds * 1000L;
                break;
            }
            case FOREVER: {
                DateTime now = new DateTime();
                DateTime year = now.plusYears(5);
                this.cacheTimeoutMilli = new Interval((ReadableInstant)now, (ReadableInstant)year).toDurationMillis();
                break;
            }
        }
        log.info("Resource Filter Initialized [cacheMode=%s, cacheTimeoutSeconds=%s]", new Object[]{this.cacheMode, this.cacheTimeoutMilli});
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (!httpResponse.containsHeader("Expires")) {
            HTTP.setExpireHeaders(httpResponse, this.cacheTimeoutMilli);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

