/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sets {
    public static <E> Set<E> intersection(Collection ... sets) {
        Set result = Sets.make();
        if (sets.length > 0) {
            result.addAll(sets[0]);
        }
        for (int i = 1; i < sets.length; ++i) {
            result.retainAll(sets[i]);
        }
        return result;
    }

    public static <E> Set<E> union(Collection ... sets) {
        Set result = Sets.make();
        for (int i = 0; i < sets.length; ++i) {
            result.addAll(sets[i]);
        }
        return result;
    }

    public static <E> Set<E> difference(Collection<? extends E> set1, Collection<? extends E> set2) {
        LinkedHashSet<E> result = new LinkedHashSet<E>(set1);
        result.removeAll(set2);
        return result;
    }

    public static <E> Set<E> xor(Collection<? extends E> set1, Collection<? extends E> set2) {
        return Sets.union(Sets.difference(set1, set2), Sets.difference(set2, set1));
    }

    public static <T> Set<T> make(T ... items) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(items.length);
        for (T item : items) {
            result.add(item);
        }
        return result;
    }

    public static <T> Set<T> make() {
        return new LinkedHashSet();
    }

    public static <T> List<T> asList(Collection<? extends T> items) {
        return new ArrayList<T>(items);
    }
}

