/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class ByteFormat
extends Format {
    private static final long serialVersionUID = 979218721408472070L;
    private boolean addSpaceBeforeMarker = true;

    public ByteFormat() {
    }

    public ByteFormat(boolean spaces) {
        this.addSpaceBeforeMarker = spaces;
    }

    public String format(long bytes) {
        return this.format(new Long(bytes));
    }

    public String formatKB(long kilobytes) {
        return this.format(new Long(kilobytes * 1024L));
    }

    public StringBuffer format(Object obj, StringBuffer buf, FieldPosition pos) {
        if (obj instanceof Long) {
            long numBytes = (Long)obj;
            if (numBytes < 0x100000L) {
                DecimalFormat formatter = new DecimalFormat("#,##0.0");
                buf.append(formatter.format((double)numBytes / 1024.0));
                if (this.addSpaceBeforeMarker) {
                    buf.append(" ");
                }
                buf.append("K");
            } else {
                DecimalFormat formatter = new DecimalFormat("#,##0.0");
                buf.append(formatter.format((double)numBytes / 1048576.0));
                if (this.addSpaceBeforeMarker) {
                    buf.append(" ");
                }
                buf.append("MB");
            }
        }
        return buf;
    }

    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }
}

