/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.audio;

import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.util.Utilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class SingleFileAudioPlayer
implements AudioPlayer {
    private static final Logger LOGGER = Logger.getLogger(SingleFileAudioPlayer.class.getName());
    private AudioFormat currentFormat = null;
    private String baseName;
    private byte[] outputData;
    private int curIndex = 0;
    private int totBytes = 0;
    private AudioFileFormat.Type outputType;
    private Vector<InputStream> outputList;

    public SingleFileAudioPlayer(String baseName, AudioFileFormat.Type type) {
        this.baseName = baseName + "." + type.getExtension();
        this.outputType = type;
        this.outputList = new Vector();
    }

    public SingleFileAudioPlayer() {
        this(Utilities.getProperty("com.sun.speech.freetts.AudioPlayer.baseName", "freetts"), AudioFileFormat.Type.WAVE);
    }

    @Override
    public synchronized void setAudioFormat(AudioFormat format) {
        this.currentFormat = format;
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.currentFormat;
    }

    @Override
    public void pause() {
    }

    @Override
    public synchronized void resume() {
    }

    @Override
    public synchronized void cancel() {
    }

    @Override
    public synchronized void reset() {
    }

    @Override
    public void startFirstSampleTimer() {
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            File file = new File(this.baseName);
            SequenceInputStream is = new SequenceInputStream(this.outputList.elements());
            AudioInputStream ais = new AudioInputStream(is, this.currentFormat, this.totBytes / this.currentFormat.getFrameSize());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Avail " + ais.available());
                LOGGER.fine("totBytes " + this.totBytes);
                LOGGER.fine("FS " + this.currentFormat.getFrameSize());
            }
            LOGGER.info("Wrote synthesized speech to " + this.baseName);
            AudioSystem.write(ais, this.outputType, file);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Can't write audio type " + this.outputType, iae);
        }
    }

    @Override
    public float getVolume() {
        return 1.0f;
    }

    @Override
    public void setVolume(float volume) {
    }

    @Override
    public void begin(int size) {
        this.outputData = new byte[size];
        this.curIndex = 0;
    }

    @Override
    public boolean end() {
        this.outputList.add(new ByteArrayInputStream(this.outputData));
        this.totBytes += this.outputData.length;
        return true;
    }

    @Override
    public boolean drain() {
        return true;
    }

    @Override
    public synchronized long getTime() {
        return -1L;
    }

    @Override
    public synchronized void resetTime() {
    }

    @Override
    public boolean write(byte[] audioData) {
        return this.write(audioData, 0, audioData.length);
    }

    @Override
    public boolean write(byte[] bytes, int offset, int size) {
        System.arraycopy(bytes, offset, this.outputData, this.curIndex, size);
        this.curIndex += size;
        return true;
    }

    public String toString() {
        return "FileAudioPlayer";
    }

    @Override
    public void showMetrics() {
    }
}

