/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.Closer;
import com.voxeo.utils.ProcessCallback;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessTemplate {
    private String command;
    private List<String> arguments = new ArrayList<String>();

    public ProcessTemplate() {
    }

    public ProcessTemplate(String command, String ... args) {
        this.command = command;
        this.arguments = Arrays.asList(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(ProcessCallback callback) throws IOException, InterruptedException {
        LinkedList<String> commandChain = new LinkedList<String>(this.arguments);
        commandChain.add(0, this.command);
        ProcessBuilder builder = new ProcessBuilder(commandChain);
        builder.redirectErrorStream(true);
        Process p = builder.start();
        InputStream is = null;
        try {
            is = p.getInputStream();
            callback.go(is);
        }
        catch (Throwable throwable) {
            Closer.closeAll(is);
            throw throwable;
        }
        Closer.closeAll(is);
        return p.waitFor();
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }
}

