/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

public class IsReplicaVersionSync
extends Operation
implements PartitionAwareOperation,
MigrationCycleOperation {
    private long version;
    private transient boolean result;

    public IsReplicaVersionSync() {
    }

    public IsReplicaVersionSync(long version) {
        this.version = version;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        long[] currentVersions = partitionService.getPartitionReplicaVersions(partitionId);
        long currentVersion = currentVersions[replicaIndex - 1];
        if (currentVersion == this.version) {
            this.result = true;
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeLong(this.version);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.version = in.readLong();
    }
}

