/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.media.PullSourceStreamInputStream;
import net.sf.fmj.media.parser.XmlMovieSAXHandler;
import net.sf.fmj.media.parser.XmlMovieSAXParserThread;
import net.sf.fmj.utility.LoggerSingleton;
import org.xml.sax.SAXException;

public class XmlMovieParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("video.xml")};
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;
    private XmlMovieSAXHandler xmlMovieSAXHandler;
    private XmlMovieSAXParserThread xmlMovieSAXParserThread;

    public void close() {
        if (this.tracks != null) {
            for (int i = 0; i < this.tracks.length; ++i) {
                if (this.tracks[i] == null) continue;
                this.tracks[i].deallocate();
                this.tracks[i] = null;
            }
            this.tracks = null;
        }
        super.close();
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public boolean isPositionable() {
        return false;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    public void open() throws ResourceUnavailableException {
        try {
            this.source.start();
            PullSourceStream[] pullSourceStreamArray = this.source.getStreams();
            if (pullSourceStreamArray.length > 1) {
                logger.warning("only 1 stream supported, " + pullSourceStreamArray.length + " found");
            }
            PullSourceStreamInputStream pullSourceStreamInputStream = new PullSourceStreamInputStream(pullSourceStreamArray[0]);
            this.xmlMovieSAXHandler = new XmlMovieSAXHandler();
            this.xmlMovieSAXParserThread = new XmlMovieSAXParserThread(this.xmlMovieSAXHandler, pullSourceStreamInputStream);
            this.xmlMovieSAXParserThread.start();
            Format[] formatArray = this.xmlMovieSAXHandler.readTracksInfo();
            this.tracks = new PullSourceStreamTrack[formatArray.length];
            for (int i = 0; i < formatArray.length; ++i) {
                this.tracks[i] = new VideoTrack(i, formatArray[i]);
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
            throw new ResourceUnavailableException("" + iOException);
        }
        catch (SAXException sAXException) {
            logger.log(Level.WARNING, "" + sAXException, sAXException);
            throw new ResourceUnavailableException("" + sAXException);
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.WARNING, "" + interruptedException, interruptedException);
            throw new ResourceUnavailableException("" + interruptedException);
        }
        super.open();
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        dataSource.getLocator().getProtocol();
        if (!(dataSource instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)dataSource;
    }

    public void start() throws IOException {
    }

    private class VideoTrack
    extends PullSourceStreamTrack {
        private final int track;
        private final Format format;

        public VideoTrack(int n, Format format) throws ResourceUnavailableException {
            this.track = n;
            this.format = format;
        }

        public void deallocate() {
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }

        public Format getFormat() {
            return this.format;
        }

        public Time mapFrameToTime(int n) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time time) {
            return Integer.MAX_VALUE;
        }

        public void readFrame(Buffer buffer) {
            Buffer buffer2;
            try {
                buffer2 = XmlMovieParser.this.xmlMovieSAXHandler.readBuffer(this.track);
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            buffer.copy(buffer2);
        }
    }

    private abstract class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStreamTrack() {
        }

        public abstract void deallocate();
    }
}

