/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import org.jitsi.impl.neomedia.codec.audio.silk.ControlCodecFLP;
import org.jitsi.impl.neomedia.codec.audio.silk.DetectSWBInput;
import org.jitsi.impl.neomedia.codec.audio.silk.EncodeFrameFLP;
import org.jitsi.impl.neomedia.codec.audio.silk.InitEncoderFLP;
import org.jitsi.impl.neomedia.codec.audio.silk.Macros;
import org.jitsi.impl.neomedia.codec.audio.silk.Resampler;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_SILK_SDK_EncControlStruct;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_encoder_state_FLP;

public class EncAPI {
    static int frame_cnt = 0;

    static int SKP_Silk_SDK_QueryEncoder(Object encState, SKP_SILK_SDK_EncControlStruct encStatus) {
        int ret = 0;
        SKP_Silk_encoder_state_FLP psEnc = (SKP_Silk_encoder_state_FLP)encState;
        encStatus.API_sampleRate = psEnc.sCmn.API_fs_Hz;
        encStatus.maxInternalSampleRate = Macros.SKP_SMULBB(psEnc.sCmn.maxInternal_fs_kHz, 1000);
        encStatus.packetSize = psEnc.sCmn.API_fs_Hz * psEnc.sCmn.PacketSize_ms / 1000;
        encStatus.bitRate = psEnc.sCmn.TargetRate_bps;
        encStatus.packetLossPercentage = psEnc.sCmn.PacketLoss_perc;
        encStatus.complexity = psEnc.sCmn.Complexity;
        encStatus.useInBandFEC = psEnc.sCmn.useInBandFEC;
        encStatus.useDTX = psEnc.sCmn.useDTX;
        return ret;
    }

    static int SKP_Silk_SDK_InitEncoder(Object encState, SKP_SILK_SDK_EncControlStruct encStatus) {
        int ret = 0;
        SKP_Silk_encoder_state_FLP psEnc = (SKP_Silk_encoder_state_FLP)encState;
        if ((ret += InitEncoderFLP.SKP_Silk_init_encoder_FLP(psEnc)) != 0) assert (false);
        if ((ret += EncAPI.SKP_Silk_SDK_QueryEncoder(encState, encStatus)) != 0) assert (false);
        return ret;
    }

    static int SKP_Silk_SDK_Encode(Object encState, SKP_SILK_SDK_EncControlStruct encControl, short[] samplesIn, int samplesIn_offset, int nSamplesIn, byte[] outData, int outData_offset, short[] nBytesOut) {
        int ret = 0;
        int nSamplesFromInput = 0;
        SKP_Silk_encoder_state_FLP psEnc = (SKP_Silk_encoder_state_FLP)encState;
        assert (encControl != null);
        if (encControl.API_sampleRate != 8000 && encControl.API_sampleRate != 12000 && encControl.API_sampleRate != 16000 && encControl.API_sampleRate != 24000 && encControl.API_sampleRate != 32000 && encControl.API_sampleRate != 44100 && encControl.API_sampleRate != 48000 || encControl.maxInternalSampleRate != 8000 && encControl.maxInternalSampleRate != 12000 && encControl.maxInternalSampleRate != 16000 && encControl.maxInternalSampleRate != 24000) {
            ret = -2;
            assert (false);
            return ret;
        }
        int API_fs_Hz = encControl.API_sampleRate;
        int max_internal_fs_kHz = encControl.maxInternalSampleRate / 1000;
        int PacketSize_ms = 1000 * encControl.packetSize / API_fs_Hz;
        int TargetRate_bps = encControl.bitRate;
        int PacketLoss_perc = encControl.packetLossPercentage;
        int UseInBandFEC = encControl.useInBandFEC;
        int Complexity = encControl.complexity;
        int UseDTX = encControl.useDTX;
        psEnc.sCmn.API_fs_Hz = API_fs_Hz;
        psEnc.sCmn.maxInternal_fs_kHz = max_internal_fs_kHz;
        psEnc.sCmn.useInBandFEC = UseInBandFEC;
        int input_ms = 1000 * nSamplesIn / API_fs_Hz;
        if (input_ms % 10 != 0 || nSamplesIn < 0) {
            ret = -1;
            assert (false);
            return ret;
        }
        if (nSamplesIn > psEnc.sCmn.PacketSize_ms * API_fs_Hz / 1000) {
            ret = -1;
            assert (false);
            return ret;
        }
        ret = ControlCodecFLP.SKP_Silk_control_encoder_FLP(psEnc, API_fs_Hz, max_internal_fs_kHz, PacketSize_ms, TargetRate_bps, PacketLoss_perc, UseInBandFEC, UseDTX, input_ms, Complexity);
        if (ret != 0) {
            assert (false);
            return ret;
        }
        if (Math.min(API_fs_Hz, 1000 * max_internal_fs_kHz) == 24000 && psEnc.sCmn.sSWBdetect.SWB_detected == 0 && psEnc.sCmn.sSWBdetect.WB_detected == 0) {
            DetectSWBInput.SKP_Silk_detect_SWB_input(psEnc.sCmn.sSWBdetect, samplesIn, samplesIn_offset, nSamplesIn);
        }
        short MaxBytesOut = 0;
        while (true) {
            int nSamplesToBuffer = psEnc.sCmn.frame_length - psEnc.sCmn.inputBufIx;
            if (API_fs_Hz == Macros.SKP_SMULBB(1000, psEnc.sCmn.fs_kHz)) {
                nSamplesFromInput = nSamplesToBuffer = Math.min(nSamplesToBuffer, nSamplesIn);
                System.arraycopy(samplesIn, samplesIn_offset, psEnc.sCmn.inputBuf, psEnc.sCmn.inputBufIx, nSamplesFromInput);
            } else {
                nSamplesToBuffer = Math.min(nSamplesToBuffer, nSamplesIn * psEnc.sCmn.fs_kHz * 1000 / API_fs_Hz);
                nSamplesFromInput = nSamplesToBuffer * API_fs_Hz / (psEnc.sCmn.fs_kHz * 1000);
                ret += Resampler.SKP_Silk_resampler(psEnc.sCmn.resampler_state, psEnc.sCmn.inputBuf, psEnc.sCmn.inputBufIx, samplesIn, samplesIn_offset, nSamplesFromInput);
            }
            samplesIn_offset += nSamplesFromInput;
            nSamplesIn -= nSamplesFromInput;
            psEnc.sCmn.inputBufIx += nSamplesToBuffer;
            if (psEnc.sCmn.inputBufIx < psEnc.sCmn.frame_length) break;
            if (MaxBytesOut == 0) {
                MaxBytesOut = nBytesOut[0];
                short[] MaxBytesOut_ptr = new short[]{MaxBytesOut};
                ret = EncodeFrameFLP.SKP_Silk_encode_frame_FLP(psEnc, outData, outData_offset, MaxBytesOut_ptr, psEnc.sCmn.inputBuf, 0);
                if (ret != 0) assert (false);
                MaxBytesOut = MaxBytesOut_ptr[0];
            } else {
                ret = EncodeFrameFLP.SKP_Silk_encode_frame_FLP(psEnc, outData, outData_offset, nBytesOut, psEnc.sCmn.inputBuf, 0);
                if (ret != 0) assert (false);
                assert (nBytesOut[0] == 0);
            }
            psEnc.sCmn.inputBufIx = 0;
        }
        nBytesOut[0] = MaxBytesOut;
        if (psEnc.sCmn.useDTX != 0 && psEnc.sCmn.inDTX != 0) {
            nBytesOut[0] = 0;
        }
        return ret;
    }
}

