/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.application;

import com.lti.utils.PathUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.MediaLocator;
import javax.media.format.AudioFormat;
import javax.media.protocol.FileTypeDescriptor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.sf.fmj.gui.controlpanel.SwingLookControlPanel;
import net.sf.fmj.ui.application.CaptureDeviceBrowser;
import net.sf.fmj.ui.application.ContainerPlayer;
import net.sf.fmj.ui.application.ContainerPlayerStatusListener;
import net.sf.fmj.ui.application.PlayerPanelPrefs;
import net.sf.fmj.ui.dialogs.RTPReceivePanel;
import net.sf.fmj.ui.dialogs.URLPanel;
import net.sf.fmj.ui.wizards.RTPTransmitWizard;
import net.sf.fmj.ui.wizards.TrackConfig;
import net.sf.fmj.ui.wizards.TranscodeWizard;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;

public class PlayerPanel
extends JPanel {
    private static final Logger logger = LoggerSingleton.logger;
    private PlayerPanelPrefs prefs;
    private JToolBar playerToolBar = null;
    private JButton openButton = null;
    private JButton openCaptureDeviceButton = null;
    private SwingLookControlPanel transportControlPanel = null;
    private JLabel statusBar = null;
    private JPanel videoPanel = null;
    private JComboBox addressComboBox = null;
    private JButton loadButton = null;
    private JPanel addressPanel = null;
    private JLabel locationLabel = null;
    private ContainerPlayer containerPlayer = null;

    public PlayerPanel() {
        this.initialize();
    }

    public void addMediaLocatorAndLoad(String string) {
        boolean bl = false;
        for (int i = 0; i < this.getAddressComboBox().getItemCount(); ++i) {
            if (!this.getAddressComboBox().getItemAt(i).equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.getAddressComboBox().addItem(string);
        }
        if (this.getAddressComboBox().getSelectedItem() == null || !this.getAddressComboBox().getSelectedItem().equals(string)) {
            this.getAddressComboBox().setSelectedItem(string);
        } else {
            this.onLoadButtonClick();
        }
    }

    private JComboBox getAddressComboBox() {
        if (this.addressComboBox == null) {
            this.addressComboBox = new JComboBox();
            this.addressComboBox.setEditable(true);
            this.addressComboBox.setPreferredSize(new Dimension(400, 27));
            for (String string : this.prefs.recentUrls) {
                this.addressComboBox.addItem(string);
            }
            this.addressComboBox.setSelectedIndex(-1);
            this.addressComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    logger.fine("addressComboBox state change: " + itemEvent);
                    if (itemEvent.getStateChange() == 1) {
                        PlayerPanel.this.onLoadButtonClick();
                    }
                }
            });
        }
        return this.addressComboBox;
    }

    private JPanel getAddressPanel() {
        if (this.addressPanel == null) {
            this.locationLabel = new JLabel();
            this.locationLabel.setText("Location:");
            this.addressPanel = new JPanel();
            this.addressPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 2, 0, 2);
            this.addressPanel.add((Component)this.locationLabel, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 2, 0, 2);
            this.addressPanel.add((Component)this.getAddressComboBox(), gridBagConstraints2);
        }
        return this.addressPanel;
    }

    private ContainerPlayer getContainerPlayer() {
        if (this.containerPlayer == null) {
            this.containerPlayer = new ContainerPlayer(this.getVideoPanel());
            this.containerPlayer.setAutoLoop(this.prefs.autoLoop);
            this.containerPlayer.setContainerPlayerStatusListener(new ContainerPlayerStatusListener(){

                public void onStatusChange(final String string) {
                    logger.fine("Status change: " + string);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            PlayerPanel.this.statusBar.setText(string);
                        }
                    });
                }
            });
        }
        return this.containerPlayer;
    }

    private JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setToolTipText("Load selected location");
            this.loadButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/fmj/ui/images/import_wiz.png")));
            this.loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlayerPanel.this.onLoadButtonClick();
                }
            });
        }
        return this.loadButton;
    }

    private JButton getOpenButton() {
        if (this.openButton == null) {
            this.openButton = new JButton();
            this.openButton.setToolTipText("Browse for media file...");
            this.openButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/fmj/ui/images/cvs_folder_rep.png")));
            this.openButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlayerPanel.this.onOpenFile();
                }
            });
        }
        return this.openButton;
    }

    private JButton getOpenCaptureDeviceButton() {
        if (this.openCaptureDeviceButton == null) {
            this.openCaptureDeviceButton = new JButton();
            this.openCaptureDeviceButton.setToolTipText("Select capture device...");
            this.openCaptureDeviceButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/fmj/ui/images/webcam.png")));
            this.openCaptureDeviceButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlayerPanel.this.onOpenCaptureDevice();
                }
            });
        }
        return this.openCaptureDeviceButton;
    }

    private Frame getParentFrame() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Frame)) continue;
            return (Frame)container;
        }
        throw new RuntimeException("No parent frame");
    }

    private JToolBar getPlayerToolBar() {
        if (this.playerToolBar == null) {
            this.playerToolBar = new JToolBar();
            this.playerToolBar.setFloatable(false);
            this.playerToolBar.add(this.getOpenButton());
            this.playerToolBar.add(this.getOpenCaptureDeviceButton());
            this.playerToolBar.add(this.getAddressPanel());
            this.playerToolBar.add(this.getLoadButton());
        }
        return this.playerToolBar;
    }

    public PlayerPanelPrefs getPrefs() {
        return this.prefs;
    }

    private JLabel getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new JLabel();
            this.statusBar.setText(" ");
        }
        return this.statusBar;
    }

    private SwingLookControlPanel getTransportControlPanel() {
        if (this.transportControlPanel == null) {
            this.transportControlPanel = this.getContainerPlayer().getTransportControlPanel();
        }
        return this.transportControlPanel;
    }

    public JPanel getVideoPanel() {
        if (this.videoPanel == null) {
            this.videoPanel = new JPanel();
            this.videoPanel.setLayout(new BorderLayout());
            this.videoPanel.setBackground(SystemColor.controlShadow);
        }
        return this.videoPanel;
    }

    private void initialize() {
        this.loadPrefs();
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(363, 218));
        this.add((Component)this.getPlayerToolBar(), "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.add((Component)jPanel, "South");
        jPanel.add((Component)this.getTransportControlPanel(), "North");
        jPanel.add((Component)this.getStatusBar(), "South");
        this.add((Component)this.getVideoPanel(), "Center");
    }

    private void loadPrefs() {
        try {
            File file = PlayerPanelPrefs.getFile();
            if (!file.exists()) {
                logger.fine("FMJStudio prefs file does not exist.  Using defaults.");
                this.setDefaultPrefs();
                return;
            }
            FileReader fileReader = new FileReader(file);
            this.prefs = new PlayerPanelPrefs();
            this.prefs.load(fileReader);
        }
        catch (Exception exception) {
            logger.warning("Problem loading FMJStudio prefs: " + exception + ".  Using defaults.");
            this.setDefaultPrefs();
        }
    }

    public void onAutoLoop(boolean bl) {
        this.prefs.autoLoop = bl;
        if (this.containerPlayer != null) {
            this.containerPlayer.setAutoLoop(bl);
        }
        this.savePrefs();
    }

    public void onAutoPlay(boolean bl) {
        logger.fine("onAutoPlay: " + bl);
        this.prefs.autoPlay = bl;
        this.savePrefs();
    }

    private void onLoadButtonClick() {
        String string = (String)this.getAddressComboBox().getSelectedItem();
        if (string.trim().equals("")) {
            this.showError("No URL specified");
            return;
        }
        this.setCursor(new Cursor(3));
        try {
            this.getContainerPlayer().setMediaLocation(string, this.prefs.autoPlay);
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "" + throwable, throwable);
            this.showError("" + throwable);
            return;
        }
        finally {
            this.setCursor(new Cursor(0));
        }
        if (!this.prefs.recentUrls.contains(string)) {
            this.prefs.recentUrls.add(0, string);
            this.savePrefs();
        } else if (!this.prefs.recentUrls.get(0).equals(string)) {
            this.prefs.recentUrls.remove(string);
            this.prefs.recentUrls.add(0, string);
            this.savePrefs();
        }
    }

    public void onOpenCaptureDevice() {
        MediaLocator mediaLocator = CaptureDeviceBrowser.run(this.getParentFrame());
        if (mediaLocator != null) {
            this.addMediaLocatorAndLoad(mediaLocator.toExternalForm());
        }
    }

    public void onOpenFile() {
        JFileChooser jFileChooser = new JFileChooser();
        if (jFileChooser.showOpenDialog(this) == 0) {
            String string = URLUtils.createUrlStr(jFileChooser.getSelectedFile());
            this.addMediaLocatorAndLoad(string);
        }
    }

    public void onOpenURL() {
        String string = URLPanel.run(this.getParentFrame());
        if (string == null) {
            return;
        }
        this.addMediaLocatorAndLoad(string);
    }

    public void onReceiveRTP() {
        String string = RTPReceivePanel.run(this.getParentFrame());
        if (string == null) {
            return;
        }
        this.addMediaLocatorAndLoad(string);
    }

    public void onTranscode() {
        TranscodeWizard transcodeWizard = new TranscodeWizard(this.getParentFrame(), this.prefs.transcodeWizardConfig);
        boolean bl = transcodeWizard.run();
        if (bl) {
            this.containerPlayer.setRealizedStartedProcessor(transcodeWizard.getResult().processor);
            this.prefs.transcodeWizardConfig = transcodeWizard.getConfig();
            this.savePrefs();
        }
    }

    public void onTransmitRTP() {
        RTPTransmitWizard rTPTransmitWizard = new RTPTransmitWizard(this.getParentFrame(), this.prefs.rtpTransmitWizardConfig);
        boolean bl = rTPTransmitWizard.run();
        if (bl) {
            this.containerPlayer.setRealizedStartedProcessor(rTPTransmitWizard.getResult().processor);
            this.prefs.rtpTransmitWizardConfig = rTPTransmitWizard.getConfig();
            this.savePrefs();
        }
    }

    private void savePrefs() {
        try {
            FileWriter fileWriter = new FileWriter(PlayerPanelPrefs.getFile());
            this.prefs.write(fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "savePrefs failed: " + exception, exception);
        }
    }

    private void setDefaultPrefs() {
        this.prefs = new PlayerPanelPrefs();
        this.prefs.recentUrls.add("http://stream.lrz-muenchen.de:31337/m945-hq.ogg");
        this.prefs.recentUrls.add("http://stream.lrz-muenchen.de:31337/m945-hq.mp3");
        this.prefs.recentUrls.add("file://samplemedia/hen.mp3");
        this.prefs.recentUrls.add("file://samplemedia/lion_roar.mp3");
        this.prefs.recentUrls.add("file://samplemedia/betterway.wav");
        this.prefs.recentUrls.add("file://samplemedia/issues.au");
        this.prefs.recentUrls.add("file://samplemedia/gulp.wav");
        this.prefs.recentUrls.add("file://samplemedia/gulp2.wav");
        this.prefs.recentUrls.add("file://samplemedia/Gloria_Patri.ogg");
        this.prefs.recentUrls.add("file://samplemedia/safexmas.mov");
        this.prefs.recentUrls.add("http://fmj.larsontechnologies.com/samplemedia/Apollo_15_liftoff_from_inside_LM.ogg");
        this.prefs.recentUrls.add("http://www.surfshooterhawaii.com//cgi-bin/axispush555.cgi?dummy=garb");
        this.prefs.recentUrls.add("http://towercam.uu.edu/axis-cgi/mjpg/video.cgi");
        this.prefs.recentUrls.add("http://www.easylife.org/386dx/smells.mp3");
        this.prefs.rtpTransmitWizardConfig.url = "file://samplemedia/gulp2.wav";
        this.prefs.rtpTransmitWizardConfig.trackConfigs = new TrackConfig[]{new TrackConfig(true, new AudioFormat("ULAW/rtp", 8000.0, 8, 1, 0, 1))};
        this.prefs.rtpTransmitWizardConfig.destUrl = "rtp://192.168.1.4:8000/audio/16";
        this.prefs.transcodeWizardConfig.url = "file://samplemedia/gulp2.wav";
        this.prefs.transcodeWizardConfig.contentDescriptor = new FileTypeDescriptor("audio.x_wav");
        this.prefs.transcodeWizardConfig.trackConfigs = new TrackConfig[]{new TrackConfig(true, new AudioFormat("LINEAR", 8000.0, 8, 1, -1, 0))};
        this.prefs.transcodeWizardConfig.destUrl = URLUtils.createUrlStr(new File(PathUtils.getTempPath(), "gulp2-transcoded.wav"));
        this.savePrefs();
    }

    private void showError(String string) {
        JOptionPane.showConfirmDialog(this, string, "Error", -1, 0);
    }
}

