/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class RTCPSenderInfo {
    public static final int SIZE = 20;
    private static final long MSB_0_BASE_TIME = 2085978496000L;
    public static final long MSB_1_BASE_TIME = -2208988800000L;
    private long ntpTimestampMSW = 0L;
    private long ntpTimestampLSW = 0L;
    private long rtpTimestamp = 0L;
    private long packetCount = 0L;
    private long octetCount = 0L;

    public RTCPSenderInfo(byte[] byArray, int n, int n2) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, n, n2));
        this.ntpTimestampMSW = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        this.ntpTimestampLSW = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        this.rtpTimestamp = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        this.packetCount = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        this.octetCount = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
    }

    public long getNtpTimestampLSW() {
        return this.ntpTimestampLSW;
    }

    public long getNtpTimestampMSW() {
        return this.ntpTimestampMSW;
    }

    public double getNtpTimestampSecs() {
        return (double)this.getTimestamp() / 1000.0;
    }

    public long getOctetCount() {
        return this.octetCount;
    }

    public long getPacketCount() {
        return this.packetCount;
    }

    public long getRtpTimestamp() {
        return this.rtpTimestamp;
    }

    public long getTimestamp() {
        long l = this.ntpTimestampMSW;
        long l2 = this.ntpTimestampLSW;
        l2 = Math.round(1000.0 * (double)l2 / 4.294967296E9);
        long l3 = l & 0x80000000L;
        if (l3 == 0L) {
            return 2085978496000L + l * 1000L + l2;
        }
        return -2208988800000L + l * 1000L + l2;
    }

    public String toString() {
        String string = "";
        string = string + "ntp_ts=" + this.getNtpTimestampMSW();
        string = string + " " + this.getNtpTimestampLSW();
        string = string + " rtp_ts=" + this.getRtpTimestamp();
        string = string + " packet_ct=" + this.getPacketCount();
        string = string + " octect_ct=" + this.getOctetCount();
        return string;
    }
}

