/*
 * Decompiled with CFR 0.152.
 */
package javax.media.rtp;

import java.io.Serializable;
import java.net.InetAddress;

public class SessionAddress
implements Serializable {
    private InetAddress m_dataAddress;
    private InetAddress m_controlAddress;
    private int m_dataPort = -1;
    private int m_controlPort = -1;
    private int ttl;
    public static final int ANY_PORT = -1;

    public SessionAddress() {
    }

    public SessionAddress(InetAddress inetAddress, int n) {
        this(inetAddress, n, 0);
    }

    public SessionAddress(InetAddress inetAddress, int n, int n2) {
        this(inetAddress, n, inetAddress, n + 1);
        this.ttl = n2;
    }

    public SessionAddress(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) {
        this.m_dataAddress = inetAddress;
        this.m_dataPort = n;
        this.m_controlAddress = inetAddress2;
        this.m_controlPort = n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SessionAddress)) {
            return false;
        }
        SessionAddress sessionAddress = (SessionAddress)object;
        return this.getControlAddress().equals(sessionAddress.getControlAddress()) && this.getDataAddress().equals(sessionAddress.getDataAddress()) && this.getControlPort() == sessionAddress.getControlPort() && this.getDataPort() == sessionAddress.getDataPort();
    }

    public InetAddress getControlAddress() {
        return this.m_controlAddress;
    }

    public String getControlHostAddress() {
        return this.m_controlAddress.getHostAddress();
    }

    public int getControlPort() {
        return this.m_controlPort;
    }

    public InetAddress getDataAddress() {
        return this.m_dataAddress;
    }

    public String getDataHostAddress() {
        return this.m_dataAddress.getHostAddress();
    }

    public int getDataPort() {
        return this.m_dataPort;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public int hashCode() {
        return this.getControlAddress().hashCode() + this.getDataAddress().hashCode() + this.getControlPort() + this.getDataPort();
    }

    public void setControlHostAddress(InetAddress inetAddress) {
        this.m_controlAddress = inetAddress;
    }

    public void setControlPort(int n) {
        this.m_controlPort = n;
    }

    public void setDataHostAddress(InetAddress inetAddress) {
        this.m_dataAddress = inetAddress;
    }

    public void setDataPort(int n) {
        this.m_dataPort = n;
    }

    public String toString() {
        return "DataAddress: " + this.m_dataAddress + "\nControlAddress: " + this.m_controlAddress + "\nDataPort: " + this.m_dataPort + "\nControlPort: " + this.m_controlPort;
    }
}

