/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.services;

import f00f.net.irc.martyr.GenericAutoService;
import f00f.net.irc.martyr.IRCConnection;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.State;
import f00f.net.irc.martyr.TimerTaskCommand;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.NickCommand;
import f00f.net.irc.martyr.commands.PassCommand;
import f00f.net.irc.martyr.commands.UserCommand;
import f00f.net.irc.martyr.errors.NickInUseError;
import f00f.net.irc.martyr.util.FullNick;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class AutoRegister
extends GenericAutoService {
    static Logger log = Logger.getLogger(AutoRegister.class);
    private long nickTimerTaskDelay = 10000L;
    private TimerTaskCommand nickTimerTask;
    private String originalNick;
    private String lastTryNick = null;
    private String user;
    private String name;
    private String pass;
    private Iterator nickIterator = null;
    private int attempt = 0;
    public static final int MAX_ATTEMPTS = 5;

    public AutoRegister(IRCConnection connection, String nick, String user, String name) {
        super(connection);
        this.originalNick = nick;
        this.user = user;
        this.name = name;
        this.pass = null;
        this.enable();
    }

    public AutoRegister(IRCConnection connection, String nick, String user, String name, String pass) {
        super(connection);
        this.originalNick = nick;
        this.user = user;
        this.name = name;
        this.pass = pass;
        this.enable();
    }

    protected Iterator getNickIterator(String baseNick) {
        return new UnderscoreIterator(baseNick);
    }

    protected void updateState(State state) {
        log.debug((Object)("AutoRegister: Update with state " + state));
        if (state == State.UNREGISTERED) {
            this.nickIterator = this.getNickIterator(this.originalNick);
            this.attempt = 0;
            this.doRegister();
        } else if (state == State.REGISTERED) {
            ClientState clientState = this.getConnection().getClientState();
            clientState.setNick(new FullNick(this.lastTryNick));
            clientState.setName(this.name);
            clientState.setUser(this.user);
            clientState.setPass(this.pass);
        }
        log.debug((Object)("AutoRegister: Returned from " + state));
    }

    protected void updateCommand(InCommand command) {
        NickCommand nickCmd;
        if (command instanceof NickInUseError) {
            NickInUseError nickErr = (NickInUseError)command;
            if (nickErr.getNick().getNick().equals(this.originalNick)) {
                this.cancelNickAttempt();
                this.scheduleNickAttempt();
            }
            if (this.getConnection().getState() == State.UNREGISTERED) {
                this.doRegister();
            }
        } else if (command instanceof NickCommand && (nickCmd = (NickCommand)command).getOldNick().equalsIgnoreCase(this.originalNick)) {
            this.cancelNickAttempt();
        }
    }

    private void scheduleNickAttempt() {
        if (this.getConnection().getState().equals(State.REGISTERED)) {
            return;
        }
        if (this.nickTimerTask == null || !this.nickTimerTask.isScheduled()) {
            this.nickTimerTask = new TimerTaskCommand(this.getConnection(), new NickCommand(this.originalNick));
            this.getConnection().getCronManager().schedule((TimerTask)this.nickTimerTask, this.nickTimerTaskDelay);
        }
    }

    private void cancelNickAttempt() {
        if (this.nickTimerTask != null && this.nickTimerTask.isScheduled()) {
            this.nickTimerTask.cancel();
        }
    }

    private void doRegister() {
        if (this.getConnection().getState() != State.UNREGISTERED) {
            log.fatal((Object)"AutoRegister: Tried to register but we are not UNREGISTERED");
            return;
        }
        if (!this.nickIterator.hasNext()) {
            log.info((Object)"AutoRegister: Failed to register.");
            this.getConnection().disconnect();
            return;
        }
        this.lastTryNick = (String)this.nickIterator.next();
        ++this.attempt;
        log.info((Object)("AutoRegister: Trying to register as " + this.lastTryNick));
        if (this.pass != null) {
            this.getConnection().sendCommand(new PassCommand(this.pass));
        }
        this.getConnection().sendCommand(new NickCommand(this.lastTryNick));
        this.getConnection().sendCommand(new UserCommand(this.user, this.name, this.getConnection()));
    }

    public String toString() {
        return "AutoRegister [" + this.attempt + "]";
    }

    private static class UnderscoreIterator
    implements Iterator {
        int count = 1;
        String nick;

        public UnderscoreIterator(String base) {
            this.nick = base;
        }

        public boolean hasNext() {
            return this.count <= 5;
        }

        public Object next() {
            if (this.hasNext()) {
                String result = this.nick;
                this.nick = this.nick + "_";
                ++this.count;
                return result;
            }
            throw new NoSuchElementException("No more nicknames");
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

