/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.SessionHandler;

public class Context
extends ContextHandler {
    public static final int SESSIONS = 1;
    public static final int SECURITY = 2;
    public static final int NO_SESSIONS = 0;
    public static final int NO_SECURITY = 0;
    protected SecurityHandler _securityHandler;
    protected ServletHandler _servletHandler;
    protected SessionHandler _sessionHandler;

    public Context() {
        this(null, null, null, null, null);
    }

    public Context(HandlerContainer parent, String contextPath) {
        this(parent, null, null, null, null);
        this.setContextPath(contextPath);
    }

    public Context(HandlerContainer parent, String contextPath, int options) {
        this(parent, (options & 1) != 0 ? new SessionHandler() : null, (options & 2) != 0 ? new SecurityHandler() : null, null, null);
        this.setContextPath(contextPath);
    }

    public Context(HandlerContainer parent, String contextPath, boolean sessions, boolean security) {
        this(parent, contextPath, (sessions ? 1 : 0) | (security ? 2 : 0));
    }

    public Context(HandlerContainer parent, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this._sessionHandler = sessionHandler;
        this._securityHandler = securityHandler;
        ServletHandler servletHandler2 = this._servletHandler = servletHandler != null ? servletHandler : new ServletHandler();
        if (this._sessionHandler != null) {
            this.setHandler(this._sessionHandler);
            if (securityHandler != null) {
                this._sessionHandler.setHandler(this._securityHandler);
                this._securityHandler.setHandler(this._servletHandler);
            } else {
                this._sessionHandler.setHandler(this._servletHandler);
            }
        } else if (this._securityHandler != null) {
            this.setHandler(this._securityHandler);
            this._securityHandler.setHandler(this._servletHandler);
        } else {
            this.setHandler(this._servletHandler);
        }
        if (errorHandler != null) {
            this.setErrorHandler(errorHandler);
        }
        if (parent != null) {
            parent.addHandler(this);
        }
    }

    protected void startContext() throws Exception {
        super.startContext();
        if (this._servletHandler != null && this._servletHandler.isStarted()) {
            this._servletHandler.initialize();
        }
    }

    public SecurityHandler getSecurityHandler() {
        return this._securityHandler;
    }

    public ServletHandler getServletHandler() {
        return this._servletHandler;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public ServletHolder addServlet(String className, String pathSpec) {
        return this._servletHandler.addServletWithMapping(className, pathSpec);
    }

    public ServletHolder addServlet(Class servlet, String pathSpec) {
        return this._servletHandler.addServletWithMapping(servlet.getName(), pathSpec);
    }

    public void addServlet(ServletHolder servlet, String pathSpec) {
        this._servletHandler.addServletWithMapping(servlet, pathSpec);
    }

    public void addFilter(FilterHolder holder, String pathSpec, int dispatches) {
        this._servletHandler.addFilterWithMapping(holder, pathSpec, dispatches);
    }

    public void addFilter(Class filterClass, String pathSpec, int dispatches) {
        this._servletHandler.addFilterWithMapping(filterClass, pathSpec, dispatches);
    }

    public void addFilter(String filterClass, String pathSpec, int dispatches) {
        this._servletHandler.addFilterWithMapping(filterClass, pathSpec, dispatches);
    }
}

