/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.GGException;
import pl.mn.communicator.GGSessionException;
import pl.mn.communicator.IConnectionService;
import pl.mn.communicator.IGGConfiguration;
import pl.mn.communicator.IServer;
import pl.mn.communicator.Server;
import pl.mn.communicator.Session;
import pl.mn.communicator.SessionState;
import pl.mn.communicator.event.ConnectionListener;
import pl.mn.communicator.event.GGPacketListener;
import pl.mn.communicator.event.PingListener;
import pl.mn.communicator.packet.GGHeader;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.handlers.PacketChain;
import pl.mn.communicator.packet.handlers.PacketContext;
import pl.mn.communicator.packet.in.GGIncomingPackage;
import pl.mn.communicator.packet.out.GGOutgoingPackage;
import pl.mn.communicator.packet.out.GGPing;

public class DefaultConnectionService
implements IConnectionService {
    private static final String WINDOW_ENCODING = "windows-1250";
    private static final Log logger = LogFactory.getLog((Class)DefaultConnectionService.class);
    private EventListenerList m_listeners = new EventListenerList();
    private Session m_session = null;
    private ConcurrentLinkedQueue m_senderQueue = new ConcurrentLinkedQueue();
    private PacketChain m_packetChain = null;
    private ConnectionThread m_connectionThread = null;
    private PingerThread m_connectionPinger = null;
    private IServer m_server = null;

    DefaultConnectionService(Session session) {
        if (session == null) {
            throw new NullPointerException("session cannot be null");
        }
        this.m_session = session;
        this.m_packetChain = new PacketChain();
    }

    public IServer lookupServer(int uin) throws GGException {
        try {
            IGGConfiguration configuration = this.m_session.getGGConfiguration();
            URL url = new URL(configuration.getServerLookupURL() + "?fmnumber=" + String.valueOf(uin));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(configuration.getSocketTimeoutInMiliseconds());
            con.setReadTimeout(configuration.getSocketTimeoutInMiliseconds());
            con.setDoInput(true);
            con.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), WINDOW_ENCODING));
            String line = reader.readLine();
            reader.close();
            return DefaultConnectionService.parseAddress(line);
        }
        catch (IOException ex) {
            throw new GGException("Unable to get default server for uin: " + String.valueOf(uin), ex);
        }
    }

    public void connect(IServer server) throws GGException {
        if (server == null) {
            throw new NullPointerException("server cannot be null");
        }
        this.m_server = server;
        this.checkConnectionState();
        this.m_session.getSessionAccessor().setSessionState(SessionState.CONNECTING);
        try {
            this.m_connectionThread = new ConnectionThread();
            this.m_connectionPinger = new PingerThread();
            this.m_connectionThread.openConnection(server.getAddress(), server.getPort());
            this.m_connectionPinger.startPinging();
        }
        catch (IOException ex) {
            this.m_session.getSessionAccessor().setSessionState(SessionState.CONNECTION_ERROR);
            throw new GGException("Unable to connect to Gadu-Gadu server: " + server, ex);
        }
    }

    public void disconnect() throws GGException {
        this.checkDisconnectionState();
        this.m_session.getSessionAccessor().setSessionState(SessionState.DISCONNECTING);
        try {
            if (this.m_connectionPinger != null) {
                this.m_connectionPinger.stopPinging();
                this.m_connectionPinger = null;
            }
            if (this.m_connectionThread != null) {
                this.m_connectionThread.closeConnection();
                this.m_connectionThread = null;
            }
            this.m_server = null;
            this.m_session.getSessionAccessor().setSessionState(SessionState.DISCONNECTED);
            this.notifyConnectionClosed();
        }
        catch (IOException ex) {
            logger.error((Object)"IOException occured while trying to disconnect", (Throwable)ex);
            this.m_session.getSessionAccessor().setSessionState(SessionState.CONNECTION_ERROR);
            throw new GGException("Unable to close connection to server", ex);
        }
    }

    private void checkDisconnectionState() throws GGSessionException {
        if (this.m_session.getSessionState() == SessionState.DISCONNECTED) {
            throw new GGSessionException(SessionState.DISCONNECTED);
        }
    }

    public boolean isConnected() {
        boolean authenticated = this.m_session.getSessionState() == SessionState.LOGGED_IN;
        boolean authenticationAwaiting = this.m_session.getSessionState() == SessionState.AUTHENTICATION_AWAITING;
        boolean connected = this.m_session.getSessionState() == SessionState.CONNECTED;
        return authenticated || authenticationAwaiting || connected;
    }

    public IServer getServer() {
        return this.m_server;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener == null) {
            throw new NullPointerException("connectionListener cannot be null");
        }
        this.m_listeners.add(ConnectionListener.class, connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        if (connectionListener == null) {
            throw new NullPointerException("connectionListener cannot be null");
        }
        this.m_listeners.remove(ConnectionListener.class, connectionListener);
    }

    public void addPacketListener(GGPacketListener packetListener) {
        if (packetListener == null) {
            throw new NullPointerException("packetListener cannot be null");
        }
        this.m_listeners.add(GGPacketListener.class, packetListener);
    }

    public void removePacketListener(GGPacketListener packetListener) {
        if (packetListener == null) {
            throw new NullPointerException("packetListener cannot be null");
        }
        this.m_listeners.remove(GGPacketListener.class, packetListener);
    }

    public void addPingListener(PingListener pingListener) {
        if (pingListener == null) {
            throw new IllegalArgumentException("pingListener cannot be null");
        }
        this.m_listeners.add(PingListener.class, pingListener);
    }

    public void removePingListener(PingListener pingListener) {
        if (pingListener == null) {
            throw new IllegalArgumentException("pingListener cannot be null");
        }
        this.m_listeners.remove(PingListener.class, pingListener);
    }

    protected void notifyConnectionEstablished() throws GGException {
        this.m_session.getSessionAccessor().setSessionState(SessionState.AUTHENTICATION_AWAITING);
        ConnectionListener[] connectionListeners = (ConnectionListener[])this.m_listeners.getListeners(ConnectionListener.class);
        for (int i = 0; i < connectionListeners.length; ++i) {
            ConnectionListener connectionListener = connectionListeners[i];
            connectionListener.connectionEstablished();
        }
    }

    protected void notifyConnectionClosed() throws GGException {
        this.m_session.getSessionAccessor().setSessionState(SessionState.DISCONNECTED);
        ConnectionListener[] connectionListeners = (ConnectionListener[])this.m_listeners.getListeners(ConnectionListener.class);
        for (int i = 0; i < connectionListeners.length; ++i) {
            ConnectionListener connectionListener = connectionListeners[i];
            connectionListener.connectionClosed();
        }
    }

    protected void notifyConnectionError(Exception ex) throws GGException {
        ConnectionListener[] connectionListeners = (ConnectionListener[])this.m_listeners.getListeners(ConnectionListener.class);
        for (int i = 0; i < connectionListeners.length; ++i) {
            ConnectionListener connectionListener = connectionListeners[i];
            connectionListener.connectionError(ex);
        }
        this.m_session.getSessionAccessor().setSessionState(SessionState.CONNECTION_ERROR);
    }

    protected void notifyPingSent() {
        PingListener[] pingListeners = (PingListener[])this.m_listeners.getListeners(PingListener.class);
        for (int i = 0; i < pingListeners.length; ++i) {
            PingListener pingListener = pingListeners[i];
            pingListener.pingSent(this.m_server);
        }
    }

    protected void notifyPongReceived() {
        PingListener[] pingListeners = (PingListener[])this.m_listeners.getListeners(PingListener.class);
        for (int i = 0; i < pingListeners.length; ++i) {
            PingListener pingListener = pingListeners[i];
            pingListener.pongReceived(this.m_server);
        }
    }

    protected void notifyPacketReceived(GGIncomingPackage incomingPackage) {
        GGPacketListener[] packetListeners = (GGPacketListener[])this.m_listeners.getListeners(GGPacketListener.class);
        for (int i = 0; i < packetListeners.length; ++i) {
            GGPacketListener packetListener = packetListeners[i];
            packetListener.receivedPacket(incomingPackage);
        }
    }

    protected void notifyPacketSent(GGOutgoingPackage outgoingPackage) {
        GGPacketListener[] packetListeners = (GGPacketListener[])this.m_listeners.getListeners(GGPacketListener.class);
        for (int i = 0; i < packetListeners.length; ++i) {
            GGPacketListener packetListener = packetListeners[i];
            packetListener.sentPacket(outgoingPackage);
        }
    }

    protected void sendPackage(GGOutgoingPackage outgoingPackage) throws IOException {
        this.m_senderQueue.add(outgoingPackage);
    }

    private void checkConnectionState() throws GGSessionException {
        if (this.m_session.getSessionState() == SessionState.CONNECTION_AWAITING) {
            return;
        }
        if (this.m_session.getSessionState() == SessionState.DISCONNECTED) {
            return;
        }
        if (this.m_session.getSessionState() == SessionState.CONNECTION_ERROR) {
            return;
        }
        throw new GGSessionException(this.m_session.getSessionState());
    }

    private static Server parseAddress(String line) {
        int tokensNumber = 3;
        StringTokenizer token = new StringTokenizer(line);
        for (int i = 0; i < 3; ++i) {
            token.nextToken();
        }
        StringTokenizer tokenizer = new StringTokenizer(token.nextToken(), ":");
        return new Server(tokenizer.nextToken(), Integer.parseInt(tokenizer.nextToken()));
    }

    private class PingerThread
    extends Thread {
        private boolean m_active = false;

        private PingerThread() {
        }

        public void run() {
            while (this.m_active && DefaultConnectionService.this.m_connectionThread.isActive()) {
                try {
                    logger.debug((Object)"Pinging...");
                    DefaultConnectionService.this.sendPackage(GGPing.getPing());
                    DefaultConnectionService.this.notifyPingSent();
                    int pingInterval = DefaultConnectionService.this.m_session.getGGConfiguration().getPingIntervalInMiliseconds();
                    Thread.sleep(pingInterval);
                }
                catch (IOException ex) {
                    this.m_active = false;
                    try {
                        DefaultConnectionService.this.notifyConnectionError(ex);
                    }
                    catch (GGException e) {
                        logger.warn((Object)"Unable to notify connection error listeners", (Throwable)ex);
                    }
                }
                catch (InterruptedException ex) {
                    this.m_active = false;
                    logger.debug((Object)"PingerThread was interruped", (Throwable)ex);
                }
            }
        }

        private void startPinging() {
            logger.debug((Object)"Starting pinging...");
            this.m_active = true;
            this.start();
        }

        private void stopPinging() {
            logger.debug((Object)"Stopping pinging...");
            this.m_active = false;
        }
    }

    private class ConnectionThread
    extends Thread {
        private static final int HEADER_LENGTH = 8;
        private Socket m_socket = null;
        private BufferedInputStream m_dataInput = null;
        private BufferedOutputStream m_dataOutput = null;
        private boolean m_active = true;

        private ConnectionThread() {
        }

        public void run() {
            try {
                while (this.m_active) {
                    this.handleInput();
                    if (!DefaultConnectionService.this.m_senderQueue.isEmpty()) {
                        this.handleOutput();
                    }
                    int sleepTime = DefaultConnectionService.this.m_session.getGGConfiguration().getConnectionThreadSleepTimeInMiliseconds();
                    Thread.sleep(sleepTime);
                }
                this.m_dataInput = null;
                this.m_dataOutput = null;
                this.m_socket.close();
            }
            catch (Exception ex) {
                try {
                    this.m_active = false;
                    DefaultConnectionService.this.notifyConnectionError(ex);
                }
                catch (GGException ex2) {
                    logger.warn((Object)"Unable to notify listeners", (Throwable)ex);
                }
            }
        }

        private void handleInput() throws IOException, GGException {
            byte[] headerData = new byte[8];
            if (this.m_dataInput.available() > 0) {
                this.m_dataInput.read(headerData);
                this.decodePacket(new GGHeader(headerData));
            }
        }

        private void handleOutput() throws IOException {
            while (!DefaultConnectionService.this.m_senderQueue.isEmpty() && !this.m_socket.isClosed() && this.m_dataOutput != null) {
                GGOutgoingPackage outgoingPackage = (GGOutgoingPackage)DefaultConnectionService.this.m_senderQueue.poll();
                this.sendPackage(outgoingPackage);
                DefaultConnectionService.this.notifyPacketSent(outgoingPackage);
            }
        }

        private boolean isActive() {
            return this.m_active;
        }

        private void openConnection(String host, int port) throws IOException {
            this.m_socket = new Socket();
            InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName(host), port);
            int socketTimeoutInMiliseconds = DefaultConnectionService.this.m_session.getGGConfiguration().getSocketTimeoutInMiliseconds();
            this.m_socket.connect(socketAddress, socketTimeoutInMiliseconds);
            this.m_socket.setKeepAlive(true);
            this.m_socket.setSoTimeout(socketTimeoutInMiliseconds);
            this.m_dataInput = new BufferedInputStream(this.m_socket.getInputStream());
            this.m_dataOutput = new BufferedOutputStream(this.m_socket.getOutputStream());
            this.start();
        }

        private void closeConnection() throws IOException {
            logger.debug((Object)"Closing connection...");
            this.m_active = false;
        }

        private synchronized void sendPackage(GGOutgoingPackage outgoingPackage) throws IOException {
            logger.debug((Object)("Sending packet: " + outgoingPackage.getPacketType() + ", packetPayLoad: " + GGUtils.prettyBytesToString(outgoingPackage.getContents())));
            this.m_dataOutput.write(GGUtils.intToByte(outgoingPackage.getPacketType()));
            this.m_dataOutput.write(GGUtils.intToByte(outgoingPackage.getLength()));
            if (outgoingPackage.getLength() > 0) {
                this.m_dataOutput.write(outgoingPackage.getContents());
            }
            this.m_dataOutput.flush();
        }

        private void decodePacket(GGHeader header) throws IOException, GGException {
            byte[] keyBytes = new byte[header.getLength()];
            this.m_dataInput.read(keyBytes);
            PacketContext context = new PacketContext(DefaultConnectionService.this.m_session, header, keyBytes);
            DefaultConnectionService.this.m_packetChain.sendToChain(context);
        }
    }
}

