/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools;

import com.lowagie.tools.Executable;
import com.lowagie.tools.ToolMenuItems;
import com.lowagie.tools.Versions;
import com.lowagie.tools.plugins.AbstractTool;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class Toolbox
extends JFrame
implements ToolMenuItems,
ActionListener {
    private static final long serialVersionUID = -3766198389452935073L;
    private JDesktopPane desktop;
    private JScrollPane console;
    private Properties toolmap = new Properties();
    private int locationX = 0;
    private int locationY = 0;
    static /* synthetic */ Class class$0;

    public Toolbox() {
        this.setSize(600, 500);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.setTitle("iText Toolbox");
        this.setJMenuBar(this.getMenubar());
        this.desktop = new JDesktopPane();
        try {
            Console c = new Console();
            this.console = new JScrollPane(c.textArea);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSplitPane splitPane = new JSplitPane(0, this.desktop, this.console);
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(300);
        this.setContentPane(splitPane);
        Toolbox.centerFrame(this);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        Toolbox toolbox = new Toolbox();
        if (args.length != 0) {
            try {
                AbstractTool tool = toolbox.createFrame(args[0]);
                String[] nargs = new String[args.length - 1];
                System.arraycopy(args, 1, nargs, 0, args.length - 1);
                tool.setArguments(nargs);
                tool.execute();
            }
            catch (PropertyVetoException propertyVetoException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
    }

    private JMenuBar getMenubar() {
        Properties p = new Properties();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.lowagie.tools.Toolbox");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            p.load(clazz.getClassLoader().getResourceAsStream("com/lowagie/tools/plugins/tools.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.toolmap = new Properties();
        TreeMap<Object, Object> tmp = new TreeMap<Object, Object>();
        tmp.putAll(p);
        JMenuBar menubar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem close = new JMenuItem("Close");
        close.setMnemonic(67);
        close.addActionListener(this);
        file.add(close);
        JMenu tools = new JMenu("Tools");
        file.setMnemonic(84);
        AbstractButton current = null;
        Iterator i = tmp.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            if (current == null || !name.startsWith(current.getText())) {
                current = new JMenu(name.substring(0, name.indexOf(46)));
                tools.add((JMenuItem)current);
            }
            JMenuItem item = new JMenuItem(name.substring(current.getText().length() + 1));
            item.addActionListener(this);
            String tool = (String)entry.getValue();
            try {
                Class.forName(tool);
                this.toolmap.put(item.getText(), tool);
                ((JMenu)current).add(item);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Plugin " + name + " was not found in your CLASSPATH.");
            }
        }
        JMenu help = new JMenu("Help");
        JMenuItem about = new JMenuItem("About");
        about.setMnemonic(65);
        about.addActionListener(this);
        help.add(about);
        JMenuItem versions = new JMenuItem("Version");
        versions.addActionListener(this);
        help.add(versions);
        menubar.add(file);
        menubar.add(tools);
        menubar.add(Box.createGlue());
        menubar.add(help);
        return menubar;
    }

    public AbstractTool createFrame(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException, PropertyVetoException {
        AbstractTool ti = (AbstractTool)Class.forName((String)this.toolmap.get(name)).newInstance();
        JInternalFrame f = ti.getInternalFrame();
        f.setLocation(this.locationX, this.locationY);
        this.locationX += 25;
        if (this.locationX > this.getWidth() + 50) {
            this.locationX = 0;
        }
        this.locationY += 25;
        if (this.locationY > this.getHeight() + 50) {
            this.locationY = 0;
        }
        f.setVisible(true);
        this.desktop.add(f);
        f.setSelected(true);
        return ti;
    }

    public static void centerFrame(JFrame f) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = f.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        f.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public void actionPerformed(ActionEvent evt) {
        if ("Close".equals(evt.getActionCommand())) {
            System.out.println("The Toolbox is closed.");
            System.exit(0);
        } else if ("About".equals(evt.getActionCommand())) {
            System.out.println("The iText Toolbox is part of iText, a Free Java-PDF Library.\nVisit http://www.lowagie.com/iText/toolbox.html for more info.");
            try {
                Executable.launchBrowser("http://www.lowagie.com/iText/toolbox.html");
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "The iText Toolbox is part of iText, a Free Java-PDF Library.\nVisit http://www.lowagie.com/iText/toolbox.html for more info.");
            }
        } else if ("Version".equals(evt.getActionCommand())) {
            Versions f = new Versions();
            Toolbox.centerFrame(f);
            f.setVisible(true);
        } else {
            try {
                this.createFrame(evt.getActionCommand());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class Console {
        PipedInputStream piOut;
        PipedInputStream piErr;
        PipedOutputStream poOut;
        PipedOutputStream poErr;
        JTextArea textArea = new JTextArea();

        public Console() throws IOException {
            this.piOut = new PipedInputStream();
            this.poOut = new PipedOutputStream(this.piOut);
            System.setOut(new PrintStream(this.poOut, true));
            this.piErr = new PipedInputStream();
            this.poErr = new PipedOutputStream(this.piErr);
            System.setErr(new PrintStream(this.poErr, true));
            this.textArea.setEditable(false);
            new ReaderThread(this.piOut).start();
            new ReaderThread(this.piErr).start();
        }

        class ReaderThread
        extends Thread {
            PipedInputStream pi;

            ReaderThread(PipedInputStream pi) {
                this.pi = pi;
            }

            public void run() {
                byte[] buf = new byte[1024];
                while (true) {
                    try {
                        int len;
                        while ((len = this.pi.read(buf)) != -1) {
                            Console.this.textArea.append(new String(buf, 0, len));
                            Console.this.textArea.setCaretPosition(Console.this.textArea.getDocument().getLength());
                        }
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

