/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.util.ImageCanvas;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class MessageBox
implements Runnable,
ActionListener,
WindowListener,
KeyListener {
    private ActionListener listener;
    private Dialog dialog;
    private String closeWindowCommand = "CloseRequested";
    private String title;
    private Frame frame;
    private boolean frameNotProvided;
    private Panel buttonPanel = new Panel();
    private Canvas imageCanvas;
    private boolean block = false;
    static /* synthetic */ Class class$com$install4j$runtime$util$MessageBox;

    public MessageBox(ActionListener actionListener) {
        this();
        this.listener = actionListener;
    }

    public MessageBox() {
    }

    public void run() {
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.dialog.setVisible(false);
        this.dialog.dispose();
        if (this.frameNotProvided) {
            this.frame.dispose();
        }
        if (this.listener != null) {
            this.listener.actionPerformed(actionEvent);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.fireCloseRequested();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.fireCloseRequested();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private void fireCloseRequested() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.closeWindowCommand);
        this.actionPerformed(actionEvent);
    }

    public void setActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setBlock(boolean bl) {
        this.block = bl;
    }

    public void setCloseWindowCommand(String string) {
        this.closeWindowCommand = string;
    }

    public void useImageCanvas(Canvas canvas) {
        this.imageCanvas = canvas;
    }

    public void useImageCanvas(String string) {
        try {
            ImageCanvas imageCanvas = new ImageCanvas(class$com$install4j$runtime$util$MessageBox == null ? (class$com$install4j$runtime$util$MessageBox = MessageBox.class$("com.install4j.runtime.util.MessageBox")) : class$com$install4j$runtime$util$MessageBox, string);
            this.useImageCanvas(imageCanvas);
        }
        catch (Exception exception) {
            System.out.println("MessageBox.helpfulHint() - Cannot load image " + string);
            exception.printStackTrace();
        }
    }

    public void addChoice(String string, String string2) {
        Button button = new Button(string);
        button.setActionCommand(string2);
        button.addActionListener(this);
        button.addKeyListener(this);
        this.buttonPanel.add(button);
    }

    public void addChoice(String string) {
        this.addChoice(string, string);
    }

    public void ask(String string) {
        Object object;
        if (this.frame == null) {
            this.frame = new Frame();
            this.frameNotProvided = true;
        } else {
            this.frameNotProvided = false;
        }
        this.dialog = new Dialog(this.frame, true);
        this.dialog.addWindowListener(this);
        this.dialog.addKeyListener(this);
        this.dialog.setTitle(this.title);
        this.dialog.setLayout(new BorderLayout(5, 5));
        Panel panel = this.createMultiLinePanel(string);
        if (this.imageCanvas == null) {
            this.dialog.add("Center", panel);
        } else {
            object = new Panel();
            ((Container)object).add(this.imageCanvas);
            ((Container)object).add(panel);
            this.dialog.add("Center", (Component)object);
        }
        this.dialog.add("South", this.buttonPanel);
        this.dialog.pack();
        this.enforceMinimumSize(this.dialog, 200, 100);
        this.centerWindow(this.dialog);
        Toolkit.getDefaultToolkit().beep();
        if (this.block) {
            this.run();
        } else {
            object = new Thread(this);
            ((Thread)object).start();
        }
    }

    public void askOkay(String string) {
        this.addChoice("Okay");
        this.ask(string);
    }

    public void askYesNo(String string) {
        this.addChoice("Yes");
        this.addChoice("No");
        this.ask(string);
    }

    private Panel createMultiLinePanel(String string) {
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        this.addMultilineString(string, panel);
        return panel;
    }

    private void addMultilineString(String string, Container container) {
        GridBagConstraints gridBagConstraints = this.getDefaultConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        while (string.length() > 0) {
            String string2;
            int n = string.indexOf(10);
            if (n >= 0) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            } else {
                string2 = string;
                string = "";
            }
            Label label = new Label(string2);
            gridBagLayout.setConstraints(label, gridBagConstraints);
            container.add(label);
        }
    }

    private GridBagConstraints getDefaultConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        return gridBagConstraints;
    }

    private void centerWindow(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width < window.getSize().width) {
            window.setSize(dimension.width, window.getSize().height);
        }
        if (dimension.height < window.getSize().height) {
            window.setSize(window.getSize().width, dimension.height);
        }
        int n = (dimension.width - window.getSize().width) / 2;
        int n2 = (dimension.height - window.getSize().height) / 2;
        window.setLocation(n, n2);
    }

    private void enforceMinimumSize(Component component, int n, int n2) {
        if (component.getSize().width < n) {
            component.setSize(n, component.getSize().height);
        }
        if (component.getSize().height < n2) {
            component.setSize(component.getSize().width, n2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

