/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.prophecy.config;

import com.voxeo.prophecy.config.IPropertyBoundConfigFile;
import com.voxeo.utils.Closer;
import com.voxeo.utils.Strings;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesFile
implements IPropertyBoundConfigFile {
    private final String encoding;
    private byte[] content;
    private Map<String, String> properties;

    public PropertiesFile(Map<String, String> props, String encoding) {
        this.encoding = encoding;
        this.content = PropertiesFile.toBytes(props, encoding);
    }

    public PropertiesFile(byte[] content, String encoding) {
        this.content = content;
        this.encoding = encoding;
    }

    @Override
    public void applyChanges(Map<String, String> props) {
        BufferedReader in = null;
        ByteArrayOutputStream bytesOut = null;
        PrintStream out = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.content), this.encoding));
            bytesOut = new ByteArrayOutputStream();
            out = new PrintStream(new BufferedOutputStream(bytesOut));
            String line = null;
            while ((line = in.readLine()) != null) {
                for (String key : props.keySet()) {
                    String s = key + "=";
                    if (!line.startsWith(s)) continue;
                    line = PropertiesFile.replaceValue(in, line, key, props.get(key));
                    break;
                }
                out.println(line);
            }
            out.flush();
            this.content = bytesOut.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Error applying changes", e);
            }
            catch (Throwable throwable) {
                Closer.closeAll(in, out);
                throw throwable;
            }
        }
        Closer.closeAll(in, out);
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = PropertiesFile.parse(this.content, this.encoding);
        }
        return this.properties;
    }

    private static final Map<String, String> parse(byte[] bytes, String encoding) {
        HashMap<Object, Object> hashMap;
        ByteArrayInputStream in = null;
        try {
            HashMap<Object, Object> map;
            in = new ByteArrayInputStream(bytes);
            Properties result = new Properties();
            result.load(in);
            hashMap = map = new HashMap<Object, Object>(result);
        }
        catch (Exception e) {
            try {
                throw new IllegalArgumentException("Error parsing XML", e);
            }
            catch (Throwable throwable) {
                Closer.closeAll(in);
                throw throwable;
            }
        }
        Closer.closeAll(in);
        return hashMap;
    }

    private static final byte[] toBytes(Map<String, String> props, String encoding) {
        byte[] byArray;
        ByteArrayOutputStream bytesOut = null;
        PrintWriter out = null;
        try {
            bytesOut = new ByteArrayOutputStream();
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(bytesOut), encoding));
            ArrayList<String> keys = new ArrayList<String>(props.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                out.format("%s=%s\n", key, Strings.isNull(props.get(key), new String[0]));
            }
            out.flush();
            byArray = bytesOut.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Error serializing XML", e);
            }
            catch (Throwable throwable) {
                Closer.closeAll(out);
                throw throwable;
            }
        }
        Closer.closeAll(out);
        return byArray;
    }

    private static String replaceValue(BufferedReader in, String line, String key, String value) throws IOException {
        while (line != null && line.endsWith("\\") && !line.endsWith("\\\\")) {
            line = in.readLine();
        }
        return key + "=" + (value == null ? "" : value);
    }

    @Override
    public boolean fromBooleanValueString(String settingValue) {
        return Boolean.valueOf(settingValue);
    }

    @Override
    public String toBooleanValueString(boolean value) {
        return Boolean.toString(value);
    }
}

