/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.messages;

import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.impl.operation.ReplicatedMapDataSerializerHook;
import com.hazelcast.replicatedmap.impl.record.VectorClockTimestamp;
import java.io.IOException;

public class ReplicationMessage<K, V>
implements IdentifiedDataSerializable {
    private String name;
    private K key;
    private V value;
    private VectorClockTimestamp vectorClockTimestamp;
    private Member origin;
    private int updateHash;
    private long ttlMillis;

    public ReplicationMessage() {
    }

    public ReplicationMessage(String name, K key, V v, VectorClockTimestamp timestamp, Member origin, int hash, long ttlMillis) {
        this.name = name;
        this.key = key;
        this.value = v;
        this.vectorClockTimestamp = timestamp;
        this.origin = origin;
        this.updateHash = hash;
        this.ttlMillis = ttlMillis;
    }

    public String getName() {
        return this.name;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public VectorClockTimestamp getVectorClockTimestamp() {
        return this.vectorClockTimestamp;
    }

    public Member getOrigin() {
        return this.origin;
    }

    public long getTtlMillis() {
        return this.ttlMillis;
    }

    public int getUpdateHash() {
        return this.updateHash;
    }

    public boolean isRemove() {
        return this.value == null;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.key);
        out.writeObject(this.value);
        this.vectorClockTimestamp.writeData(out);
        this.origin.writeData(out);
        out.writeInt(this.updateHash);
        out.writeLong(this.ttlMillis);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.key = in.readObject();
        this.value = in.readObject();
        this.vectorClockTimestamp = new VectorClockTimestamp();
        this.vectorClockTimestamp.readData(in);
        this.origin = new MemberImpl();
        this.origin.readData(in);
        this.updateHash = in.readInt();
        this.ttlMillis = in.readLong();
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 2;
    }

    public String toString() {
        return "ReplicationMessage{key=" + this.key + ", value=" + this.value + ", vectorClockTimestamp=" + this.vectorClockTimestamp + ", origin=" + this.origin + ", updateHash=" + this.updateHash + ", ttlMillis=" + this.ttlMillis + '}';
    }
}

