/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceMonitor {
    public String getStackTraceString() {
        StringBuffer stringBuffer = new StringBuffer();
        List<ThreadInfo> threadInfos = this.getThreadInfo();
        for (ThreadInfo threadInfo : threadInfos) {
            stringBuffer.append("\"").append(threadInfo.getName()).append("\" ").append(threadInfo.isDaemon() ? "daemon" : "").append(" prio=").append(threadInfo.getPriority()).append(" id=").append(threadInfo.getId()).append(" ").append((Object)threadInfo.getState()).append("\r\n");
            for (StackTraceElement line : threadInfo.getEl()) {
                stringBuffer.append("\t").append(line).append("\r\n");
            }
        }
        return stringBuffer.toString();
    }

    private List<ThreadInfo> getThreadInfo() {
        ArrayList<ThreadInfo> threadInfos = new ArrayList<ThreadInfo>();
        Map<Thread, StackTraceElement[]> st = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> e : st.entrySet()) {
            StackTraceElement[] el = e.getValue();
            Thread t = e.getKey();
            threadInfos.add(new ThreadInfo(t.getName(), t.isDaemon(), t.getPriority(), t.getId(), t.getState(), el));
        }
        Collections.sort(threadInfos, new ThreadInfoComparator());
        return threadInfos;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ThreadInfoComparator
    implements Comparator<ThreadInfo> {
        ThreadInfoComparator() {
        }

        @Override
        public int compare(ThreadInfo o1, ThreadInfo o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    class ThreadInfo {
        private final String name;
        private final boolean isDaemon;
        private final int priority;
        private final long id;
        private final Thread.State state;
        private final StackTraceElement[] el;

        ThreadInfo(String name, boolean isDaemon, int priority, long id, Thread.State state, StackTraceElement[] el) {
            this.name = name;
            this.isDaemon = isDaemon;
            this.priority = priority;
            this.id = id;
            this.state = state;
            this.el = el;
        }

        String getName() {
            return this.name;
        }

        public boolean isDaemon() {
            return this.isDaemon;
        }

        public int getPriority() {
            return this.priority;
        }

        public long getId() {
            return this.id;
        }

        public Thread.State getState() {
            return this.state;
        }

        public StackTraceElement[] getEl() {
            return this.el;
        }
    }
}

