/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer.audio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import net.sf.fmj.media.codec.JavaSoundCodec;
import net.sf.fmj.media.multiplexer.AbstractInputStreamMux;
import net.sf.fmj.media.multiplexer.InputStreamPushDataSource;
import net.sf.fmj.media.multiplexer.InputStreamPushSourceStream;
import net.sf.fmj.media.renderer.audio.JavaSoundUtils;
import net.sf.fmj.utility.LoggerSingleton;

public class AUMux
extends AbstractInputStreamMux {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean headerWritten = false;
    private boolean trailerWritten = false;
    private long bytesWritten;

    public AUMux() {
        super(new FileTypeDescriptor("audio.basic"));
    }

    public void close() {
        if (!this.trailerWritten) {
            try {
                this.outputTrailer(this.getOutputStream());
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                throw new RuntimeException(iOException);
            }
            this.trailerWritten = true;
        }
        super.close();
    }

    protected void doProcess(Buffer buffer, int n, OutputStream outputStream) throws IOException {
        if (!this.headerWritten) {
            this.outputHeader(outputStream);
            this.headerWritten = true;
        }
        if (buffer.isEOM()) {
            if (!this.trailerWritten) {
                this.outputTrailer(outputStream);
                this.trailerWritten = true;
            }
            outputStream.close();
            return;
        }
        if (buffer.isDiscard()) {
            return;
        }
        outputStream.write((byte[])buffer.getData(), buffer.getOffset(), buffer.getLength());
        this.bytesWritten += (long)buffer.getLength();
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat("LINEAR", -1.0, 8, -1, -1, 1), new AudioFormat("LINEAR", -1.0, 16, -1, 1, 1), new AudioFormat("LINEAR", -1.0, 24, -1, 1, 1), new AudioFormat("LINEAR", -1.0, 32, -1, 1, 1), new AudioFormat("ULAW"), new AudioFormat("alaw")};
    }

    public void open() throws ResourceUnavailableException {
        super.open();
        if (!this.headerWritten) {
            try {
                this.outputHeader(this.getOutputStream());
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                throw new ResourceUnavailableException("" + iOException);
            }
            this.headerWritten = true;
        }
    }

    private void outputHeader(OutputStream outputStream) throws IOException {
        byte[] byArray = JavaSoundCodec.createAuHeader(JavaSoundUtils.convertFormat((AudioFormat)this.inputFormats[0]));
        if (byArray == null) {
            throw new IOException("Unable to create AU header");
        }
        outputStream.write(byArray);
    }

    private void outputTrailer(OutputStream outputStream) throws IOException {
        InputStreamPushSourceStream inputStreamPushSourceStream;
        InputStreamPushDataSource inputStreamPushDataSource;
        PushSourceStream pushSourceStream;
        DataSource dataSource = this.getDataOutput();
        if (dataSource instanceof InputStreamPushDataSource && (pushSourceStream = (inputStreamPushDataSource = (InputStreamPushDataSource)dataSource).getStreams()[0]) instanceof InputStreamPushSourceStream && (Seekable)((Object)(inputStreamPushSourceStream = (InputStreamPushSourceStream)pushSourceStream).getTransferHandler()) instanceof Seekable) {
            ((Seekable)((Object)inputStreamPushSourceStream.getTransferHandler())).seek(8L);
            this.writeInt(outputStream, this.bytesWritten);
            if (this.getDataOutputNoInit() != null) {
                this.getDataOutputNoInit().notifyDataAvailable(0);
            }
        }
    }

    public Format setInputFormat(Format format, int n) {
        logger.finer("setInputFormat " + format + " " + n);
        boolean bl = false;
        for (Format format2 : this.getSupportedInputFormats()) {
            if (!format.matches(format2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            logger.warning("Input format does not match any supported input format: " + format);
            return null;
        }
        if (this.inputFormats != null) {
            this.inputFormats[n] = format;
        }
        return format;
    }
}

