/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;

public class RTCPRRPacket
extends RTCPPacket {
    public int ssrc;
    public RTCPReportBlock[] reports;

    public RTCPRRPacket(int ssrc, RTCPReportBlock[] reports) {
        if (reports.length > 31) {
            throw new IllegalArgumentException("Too many reports");
        }
        this.ssrc = ssrc;
        this.reports = reports;
    }

    RTCPRRPacket(RTCPPacket parent) {
        super(parent);
        this.type = 201;
    }

    public void assemble(DataOutputStream out) throws IOException {
        out.writeByte(128 + this.reports.length);
        out.writeByte(201);
        out.writeShort(1 + this.reports.length * 6);
        out.writeInt(this.ssrc);
        for (int i = 0; i < this.reports.length; ++i) {
            out.writeInt(this.reports[i].ssrc);
            out.writeInt((this.reports[i].packetslost & 0xFFFFFF) + (this.reports[i].fractionlost << 24));
            out.writeInt((int)this.reports[i].lastseq);
            out.writeInt(this.reports[i].jitter);
            out.writeInt((int)this.reports[i].lsr);
            out.writeInt((int)this.reports[i].dlsr);
        }
    }

    public int calcLength() {
        return 8 + this.reports.length * 24;
    }

    public String toString() {
        return "\tRTCP RR (receiver report) packet for sync source " + this.ssrc + ":\n" + RTCPReportBlock.toString(this.reports);
    }
}

