/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import java.io.Serializable;
import java.util.Arrays;
import javax.media.Format;
import javax.media.MediaLocator;

public class CaptureDeviceInfo
implements Serializable {
    protected Format[] formats;
    protected MediaLocator locator;
    protected String name;

    public CaptureDeviceInfo() {
    }

    public CaptureDeviceInfo(String name, MediaLocator locator, Format[] formats) {
        this.name = name;
        this.locator = locator;
        this.formats = formats;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CaptureDeviceInfo)) {
            return false;
        }
        CaptureDeviceInfo cdi = (CaptureDeviceInfo)obj;
        String name = this.getName();
        String cdiName = cdi.getName();
        if (name == null ? cdiName != null : !name.equals(cdiName)) {
            return false;
        }
        MediaLocator locator = this.getLocator();
        MediaLocator cdiLocator = cdi.getLocator();
        if (locator == null ? cdiLocator != null : !locator.equals(cdiLocator)) {
            return false;
        }
        Object[] formats = this.getFormats();
        Object[] cdiFormats = cdi.getFormats();
        return Arrays.equals(formats, cdiFormats);
    }

    public Format[] getFormats() {
        return this.formats;
    }

    public MediaLocator getLocator() {
        return this.locator;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        Format[] formats;
        MediaLocator locator;
        int hashCode = 0;
        String name = this.getName();
        if (name != null) {
            hashCode += name.hashCode();
        }
        if ((locator = this.getLocator()) != null) {
            hashCode += locator.hashCode();
        }
        if ((formats = this.getFormats()) != null) {
            for (Format format : formats) {
                if (format == null) continue;
                hashCode += format.hashCode();
            }
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.name);
        b.append(" : ");
        b.append(this.locator);
        b.append("\n");
        if (this.formats != null) {
            for (int i = 0; i < this.formats.length; ++i) {
                b.append(this.formats[i]);
                b.append("\n");
            }
        }
        return b.toString();
    }
}

