/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.List;
import javax.media.Buffer;
import org.jitsi.impl.neomedia.RTPConnectorUDPInputStream;
import org.jitsi.service.neomedia.event.RTCPFeedbackMessageEvent;
import org.jitsi.service.neomedia.event.RTCPFeedbackMessageListener;

public class RTCPConnectorInputStream
extends RTPConnectorUDPInputStream {
    private final List<RTCPFeedbackMessageListener> listeners = new ArrayList<RTCPFeedbackMessageListener>();

    public RTCPConnectorInputStream(DatagramSocket socket) {
        super(socket);
    }

    public void addRTCPFeedbackMessageListener(RTCPFeedbackMessageListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public static void fireRTCPFeedbackMessageReceived(Object source, byte[] buffer, int offset, int length, List<RTCPFeedbackMessageListener> listeners) {
        byte pt;
        if (!(length < 12 || listeners.isEmpty() || (pt = buffer[offset + 1]) != -50 && pt != -51)) {
            int fmt = buffer[offset] & 0x1F;
            RTCPFeedbackMessageEvent ev = new RTCPFeedbackMessageEvent(source, fmt, pt);
            for (RTCPFeedbackMessageListener l : listeners) {
                l.rtcpFeedbackMessageReceived(ev);
            }
        }
    }

    public void removeRTCPFeedbackMessageListener(RTCPFeedbackMessageListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected int read(Buffer buffer, byte[] data, int offset, int length) throws IOException {
        int pktLength = super.read(buffer, data, offset, length);
        RTCPConnectorInputStream.fireRTCPFeedbackMessageReceived(this, data, offset, pktLength, this.listeners);
        return pktLength;
    }
}

