/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

import net.sf.fmj.utility.ArrayUtility;

public class JpegStripper {
    private static boolean STRIP = false;

    static void dump(int[] nArray) {
        JpegStripper.dump(nArray, 10);
    }

    static void dump(int[] nArray, int n) {
        for (int i = 0; i < nArray.length / n + 1; ++i) {
            for (int j = i * n; j < i * n + n && j < nArray.length; ++j) {
                String string = Integer.toHexString(nArray[j]);
                if (string.length() < 2) {
                    string = 0 + string;
                }
                System.out.print(string + " ");
            }
            System.out.println("");
        }
        System.out.println("Length: " + nArray.length);
    }

    private static int findNextMarker(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 255 || nArray[i + 1] == 0 || nArray[i + 1] >= 208 && nArray[i + 1] <= 215) continue;
            STRIP = true;
            return i;
        }
        STRIP = false;
        return nArray.length;
    }

    public static byte[] removeHeaders(byte[] byArray) {
        int n;
        int[] nArray = new int[byArray.length];
        for (n = 0; n < byArray.length; ++n) {
            nArray[n] = byArray[n] & 0xFF;
        }
        nArray = JpegStripper.removeHeaders(nArray);
        byArray = new byte[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            byArray[n] = (byte)nArray[n];
        }
        return byArray;
    }

    public static int[] removeHeaders(int[] nArray) {
        nArray = JpegStripper.stripLeadingHeaders(nArray);
        nArray = JpegStripper.stripTrailingHeaders(nArray);
        return nArray;
    }

    private static int[] stripHeader(int[] nArray) {
        return ArrayUtility.copyOfRange(nArray, 2, nArray.length);
    }

    private static int[] stripHeaderContent(int[] nArray) {
        nArray = JpegStripper.stripHeader(nArray);
        int n = nArray[0] * 256 + nArray[1];
        return ArrayUtility.copyOfRange(nArray, n, nArray.length);
    }

    private static int[] stripLeadingHeaders(int[] nArray) {
        int[] nArray2 = nArray;
        if (nArray[0] == 255) {
            switch (nArray[1]) {
                case 192: 
                case 196: 
                case 218: 
                case 219: 
                case 221: 
                case 224: {
                    nArray2 = JpegStripper.stripHeaderContent(nArray2);
                    nArray2 = JpegStripper.stripLeadingHeaders(nArray2);
                    break;
                }
            }
            if (nArray[1] == 216) {
                nArray2 = JpegStripper.stripLeadingHeaders(JpegStripper.stripHeader(nArray2));
            }
        }
        return nArray2;
    }

    private static int[] stripOtherMarkers(int[] nArray) {
        int n = JpegStripper.findNextMarker(nArray);
        int[] nArray2 = ArrayUtility.copyOfRange(nArray, 0, n);
        return nArray2;
    }

    private static int[] stripTrailingHeaders(int[] nArray) {
        nArray = JpegStripper.stripOtherMarkers(nArray);
        if (STRIP) {
            nArray = JpegStripper.stripTrailingHeaders(nArray);
        }
        return nArray;
    }
}

