/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.media.codec.audio.ilbc;

import net.java.sip.communicator.impl.media.codec.audio.ilbc.bitstream;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_common;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_constants;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_ulp;

class ilbc_decoder {
    int consPLICount;
    int prevPLI;
    int prevLag;
    int last_lag;
    int prev_enh_pl;
    float per;
    float[] prevResidual;
    long seed;
    float[] prevLpc;
    ilbc_ulp ULP_inst = null;
    float[] syntMem;
    float[] lsfdeqold;
    float[] old_syntdenum;
    float[] hpomem;
    int use_enhancer;
    float[] enh_buf;
    float[] enh_period;

    public ilbc_decoder(int n, int n2) {
        int n3;
        this.ULP_inst = new ilbc_ulp(n);
        this.syntMem = new float[ilbc_constants.LPC_FILTERORDER];
        this.prevLpc = new float[ilbc_constants.LPC_FILTERORDER + 1];
        this.prevResidual = new float[ilbc_constants.NSUB_MAX * ilbc_constants.SUBL];
        this.old_syntdenum = new float[(ilbc_constants.LPC_FILTERORDER + 1) * ilbc_constants.NSUB_MAX];
        this.hpomem = new float[4];
        this.enh_buf = new float[ilbc_constants.ENH_BUFL];
        this.enh_period = new float[ilbc_constants.ENH_NBLOCKS_TOT];
        this.lsfdeqold = new float[ilbc_constants.LPC_FILTERORDER];
        for (n3 = 0; n3 < this.syntMem.length; ++n3) {
            this.syntMem[n3] = 0.0f;
        }
        System.arraycopy(ilbc_constants.lsfmeanTbl, 0, this.lsfdeqold, 0, ilbc_constants.LPC_FILTERORDER);
        for (n3 = 0; n3 < this.old_syntdenum.length; ++n3) {
            this.old_syntdenum[n3] = 0.0f;
        }
        for (n3 = 0; n3 < ilbc_constants.NSUB_MAX; ++n3) {
            this.old_syntdenum[n3 * (ilbc_constants.LPC_FILTERORDER + 1)] = 1.0f;
        }
        this.last_lag = 20;
        this.prevLag = 120;
        this.per = 0.0f;
        this.consPLICount = 0;
        this.prevPLI = 0;
        this.prevLpc[0] = 1.0f;
        for (n3 = 1; n3 < this.prevLpc.length; ++n3) {
            this.prevLpc[n3] = 0.0f;
        }
        for (n3 = 0; n3 < this.prevResidual.length; ++n3) {
            this.prevResidual[n3] = 0.0f;
        }
        this.seed = 777L;
        for (n3 = 0; n3 < this.hpomem.length; ++n3) {
            this.hpomem[n3] = 0.0f;
        }
        this.use_enhancer = n2;
        for (n3 = 0; n3 < this.enh_buf.length; ++n3) {
            this.enh_buf[n3] = 0.0f;
        }
        for (n3 = 0; n3 < ilbc_constants.ENH_NBLOCKS_TOT; ++n3) {
            this.enh_period[n3] = 40.0f;
        }
        this.prev_enh_pl = 0;
    }

    public void compCorr(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n, int n2, int n3) {
        if (n2 - n3 - n < 0) {
            n3 = n2 - n;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < n3; ++i) {
            f += fArray4[n2 - n3 + i] * fArray4[n2 - n3 + i - n];
            f2 += fArray4[n2 - n3 + i - n] * fArray4[n2 - n3 + i - n];
            f3 += fArray4[n2 - n3 + i] * fArray4[n2 - n3 + i];
        }
        if (f2 > 0.0f) {
            fArray[0] = f * f / f2;
            fArray2[0] = Math.abs(f / f2);
            fArray3[0] = Math.abs(f) / ((float)Math.sqrt(f2) * (float)Math.sqrt(f3));
        } else {
            fArray[0] = 0.0f;
            fArray2[0] = 0.0f;
            fArray3[0] = 0.0f;
        }
    }

    public short decode(short[] sArray, short[] sArray2, short s) {
        int n;
        float[] fArray = new float[ilbc_constants.BLOCKL_MAX];
        bitstream bitstream2 = new bitstream(this.ULP_inst.no_of_bytes);
        if (s < 0 || s > 1) {
            System.out.println("\nERROR - Wrong mode - 0, 1 allowed\n");
        }
        for (n = 0; n < sArray2.length; ++n) {
            bitstream2.buffer[2 * n + 1] = (char)(sArray2[n] & 0xFF);
            bitstream2.buffer[2 * n] = (char)(sArray2[n] >> 8 & 0xFF);
        }
        this.iLBC_decode(fArray, bitstream2, s);
        for (n = 0; n < this.ULP_inst.blockl; ++n) {
            float f = fArray[n];
            if (f < (float)ilbc_constants.MIN_SAMPLE) {
                f = ilbc_constants.MIN_SAMPLE;
            } else if (f > (float)ilbc_constants.MAX_SAMPLE) {
                f = ilbc_constants.MAX_SAMPLE;
            }
            sArray[n] = (short)f;
        }
        return (short)this.ULP_inst.blockl;
    }

    public void Decode(float[] fArray, int n, int n2, int[] nArray, float[] fArray2, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        float[] fArray3 = new float[ilbc_constants.BLOCKL_MAX];
        float[] fArray4 = new float[ilbc_constants.CB_MEML];
        int n9 = ilbc_constants.STATE_LEN - this.ULP_inst.state_short_len;
        int n10 = n3 == 1 ? (n - 1) * ilbc_constants.SUBL : (n - 1) * ilbc_constants.SUBL + n9;
        ilbc_common.StateConstructW(n2, nArray, fArray2, (n - 1) * (ilbc_constants.LPC_FILTERORDER + 1), fArray, n10, this.ULP_inst.state_short_len);
        if (n3 != 0) {
            for (n8 = 0; n8 < ilbc_constants.CB_MEML - this.ULP_inst.state_short_len; ++n8) {
                fArray4[n8] = 0.0f;
            }
            System.arraycopy(fArray, n10, fArray4, ilbc_constants.CB_MEML - this.ULP_inst.state_short_len, this.ULP_inst.state_short_len);
            ilbc_common.iCBConstruct(fArray, n10 + this.ULP_inst.state_short_len, nArray4, 0, nArray5, 0, fArray4, ilbc_constants.CB_MEML - ilbc_constants.stMemLTbl, ilbc_constants.stMemLTbl, n9, ilbc_constants.CB_NSTAGES);
        } else {
            for (n7 = 0; n7 < n9; ++n7) {
                fArray3[n7] = fArray[(n + 1) * ilbc_constants.SUBL - 1 - (n7 + this.ULP_inst.state_short_len)];
            }
            n6 = this.ULP_inst.state_short_len;
            for (n7 = 0; n7 < n6; ++n7) {
                fArray4[ilbc_constants.CB_MEML - 1 - n7] = fArray[n10 + n7];
            }
            for (n8 = 0; n8 < ilbc_constants.CB_MEML - n7; ++n8) {
                fArray4[n8] = 0.0f;
            }
            ilbc_common.iCBConstruct(fArray3, 0, nArray4, 0, nArray5, 0, fArray4, ilbc_constants.CB_MEML - ilbc_constants.stMemLTbl, ilbc_constants.stMemLTbl, n9, ilbc_constants.CB_NSTAGES);
            for (n7 = 0; n7 < n9; ++n7) {
                fArray[n10 - 1 - n7] = fArray3[n7];
            }
        }
        int n11 = 0;
        int n12 = this.ULP_inst.nsub - n - 1;
        if (n12 > 0) {
            for (n8 = 0; n8 < ilbc_constants.CB_MEML - ilbc_constants.STATE_LEN; ++n8) {
                fArray4[n8] = 0.0f;
            }
            System.arraycopy(fArray, (n - 1) * ilbc_constants.SUBL, fArray4, ilbc_constants.CB_MEML - ilbc_constants.STATE_LEN, ilbc_constants.STATE_LEN);
            for (n5 = 0; n5 < n12; ++n5) {
                ilbc_common.iCBConstruct(fArray, (n + 1 + n5) * ilbc_constants.SUBL, nArray2, n11 * ilbc_constants.CB_NSTAGES, nArray3, n11 * ilbc_constants.CB_NSTAGES, fArray4, ilbc_constants.CB_MEML - ilbc_constants.memLfTbl[n11], ilbc_constants.memLfTbl[n11], ilbc_constants.SUBL, ilbc_constants.CB_NSTAGES);
                System.arraycopy(fArray4, ilbc_constants.SUBL, fArray4, 0, ilbc_constants.CB_MEML - ilbc_constants.SUBL);
                System.arraycopy(fArray, (n + 1 + n5) * ilbc_constants.SUBL, fArray4, ilbc_constants.CB_MEML - ilbc_constants.SUBL, ilbc_constants.SUBL);
                ++n11;
            }
        }
        if ((n4 = n - 1) > 0) {
            n6 = ilbc_constants.SUBL * (this.ULP_inst.nsub + 1 - n);
            if (n6 > ilbc_constants.CB_MEML) {
                n6 = ilbc_constants.CB_MEML;
            }
            for (n7 = 0; n7 < n6; ++n7) {
                fArray4[ilbc_constants.CB_MEML - 1 - n7] = fArray[(n - 1) * ilbc_constants.SUBL + n7];
            }
            for (n8 = 0; n8 < ilbc_constants.CB_MEML - n7; ++n8) {
                fArray4[n8] = 0.0f;
            }
            for (n5 = 0; n5 < n4; ++n5) {
                ilbc_common.iCBConstruct(fArray3, n5 * ilbc_constants.SUBL, nArray2, n11 * ilbc_constants.CB_NSTAGES, nArray3, n11 * ilbc_constants.CB_NSTAGES, fArray4, ilbc_constants.CB_MEML - ilbc_constants.memLfTbl[n11], ilbc_constants.memLfTbl[n11], ilbc_constants.SUBL, ilbc_constants.CB_NSTAGES);
                System.arraycopy(fArray4, ilbc_constants.SUBL, fArray4, 0, ilbc_constants.CB_MEML - ilbc_constants.SUBL);
                System.arraycopy(fArray3, n5 * ilbc_constants.SUBL, fArray4, ilbc_constants.CB_MEML - ilbc_constants.SUBL, ilbc_constants.SUBL);
                ++n11;
            }
            for (int i = 0; i < ilbc_constants.SUBL * n4; ++i) {
                fArray[ilbc_constants.SUBL * n4 - i - 1] = fArray3[i];
            }
        }
    }

    void DecoderInterpolateLSF(float[] fArray, float[] fArray2, float[] fArray3, int n) {
        float[] fArray4 = new float[ilbc_constants.LPC_FILTERORDER + 1];
        int n2 = n;
        int n3 = n + 1;
        if (this.ULP_inst.mode == 30) {
            this.LSFinterpolate2a_dec(fArray4, this.lsfdeqold, fArray3, 0, ilbc_constants.lsf_weightTbl_30ms[0], n);
            System.arraycopy(fArray4, 0, fArray, 0, n3);
            ilbc_common.bwexpand(fArray2, 0, fArray4, ilbc_constants.LPC_CHIRP_WEIGHTDENUM, n3);
            int n4 = n3;
            for (int i = 1; i < 6; ++i) {
                this.LSFinterpolate2a_dec(fArray4, fArray3, fArray3, n2, ilbc_constants.lsf_weightTbl_30ms[i], n);
                System.arraycopy(fArray4, 0, fArray, n4, n3);
                ilbc_common.bwexpand(fArray2, n4, fArray4, ilbc_constants.LPC_CHIRP_WEIGHTDENUM, n3);
                n4 += n3;
            }
        } else {
            int n5 = 0;
            for (int i = 0; i < this.ULP_inst.nsub; ++i) {
                this.LSFinterpolate2a_dec(fArray4, this.lsfdeqold, fArray3, 0, ilbc_constants.lsf_weightTbl_20ms[i], n);
                System.arraycopy(fArray4, 0, fArray, n5, n3);
                ilbc_common.bwexpand(fArray2, n5, fArray4, ilbc_constants.LPC_CHIRP_WEIGHTDENUM, n3);
                n5 += n3;
            }
        }
        if (this.ULP_inst.mode == 30) {
            System.arraycopy(fArray3, n2, this.lsfdeqold, 0, n);
        } else {
            System.arraycopy(fArray3, 0, this.lsfdeqold, 0, n);
        }
    }

    public void doThePLC(float[] fArray, float[] fArray2, int n, float[] fArray3, float[] fArray4, int n2, int n3) {
        int n4 = 20;
        int n5 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float[] fArray5 = new float[ilbc_constants.BLOCKL_MAX];
        float[] fArray6 = new float[1];
        float[] fArray7 = new float[1];
        float[] fArray8 = new float[1];
        if (n == 1) {
            int n6;
            ++this.consPLICount;
            if (this.prevPLI != 1) {
                n4 = n3 - 3;
                fArray7[0] = f2;
                fArray6[0] = f;
                fArray8[0] = f7;
                this.compCorr(fArray7, fArray6, fArray8, this.prevResidual, n4, this.ULP_inst.blockl, 60);
                f2 = fArray7[0];
                f = fArray6[0];
                f7 = fArray8[0];
                for (n6 = n3 - 2; n6 <= n3 + 3; ++n6) {
                    fArray7[0] = f5;
                    fArray6[0] = f4;
                    fArray8[0] = f6;
                    this.compCorr(fArray7, fArray6, fArray8, this.prevResidual, n6, this.ULP_inst.blockl, 60);
                    f5 = fArray7[0];
                    f4 = fArray6[0];
                    f6 = fArray8[0];
                    if (!(f5 > f2)) continue;
                    f2 = f5;
                    f = f4;
                    n4 = n6;
                    f7 = f6;
                }
            } else {
                n4 = this.prevLag;
                f7 = this.per;
            }
            f3 = 1.0f;
            if (this.consPLICount * this.ULP_inst.blockl > 320) {
                f3 = 0.9f;
            } else if (this.consPLICount * this.ULP_inst.blockl > 640) {
                f3 = 0.7f;
            } else if (this.consPLICount * this.ULP_inst.blockl > 960) {
                f3 = 0.5f;
            } else if (this.consPLICount * this.ULP_inst.blockl > 1280) {
                f3 = 0.0f;
            }
            float f8 = (float)Math.sqrt(f7);
            float f9 = f8 > 0.7f ? 1.0f : (f8 > 0.4f ? (f8 - 0.4f) / 0.29999998f : 0.0f);
            int n7 = n4;
            if (n4 < 80) {
                n7 = 2 * n4;
            }
            float f10 = 0.0f;
            for (n6 = 0; n6 < this.ULP_inst.blockl; ++n6) {
                this.seed = this.seed * 69069L + 1L & Integer.MAX_VALUE;
                n5 = 50 + (int)(this.seed % 70L);
                int n8 = n6 - n5;
                fArray5[n6] = n8 < 0 ? this.prevResidual[this.ULP_inst.blockl + n8] : fArray5[n8];
                n8 = n6 - n7;
                fArray[n6] = n8 < 0 ? this.prevResidual[this.ULP_inst.blockl + n8] : fArray[n8];
                fArray[n6] = n6 < 80 ? f3 * (f9 * fArray[n6] + (1.0f - f9) * fArray5[n6]) : (n6 < 160 ? 0.95f * f3 * (f9 * fArray[n6] + (1.0f - f9) * fArray5[n6]) : 0.9f * f3 * (f9 * fArray[n6] + (1.0f - f9) * fArray5[n6]));
                f10 += fArray[n6] * fArray[n6];
            }
            if ((float)Math.sqrt(f10 / (float)this.ULP_inst.blockl) < 30.0f) {
                f = 0.0f;
                for (n6 = 0; n6 < this.ULP_inst.blockl; ++n6) {
                    fArray[n6] = fArray5[n6];
                }
            }
            System.arraycopy(this.prevLpc, 0, fArray2, 0, ilbc_constants.LPC_FILTERORDER + 1);
        } else {
            System.arraycopy(fArray3, 0, fArray, 0, this.ULP_inst.blockl);
            System.arraycopy(fArray4, n2, fArray2, 0, ilbc_constants.LPC_FILTERORDER + 1);
            this.consPLICount = 0;
        }
        if (n != 0) {
            this.prevLag = n4;
            this.per = f7;
        }
        this.prevPLI = n;
        System.arraycopy(fArray2, 0, this.prevLpc, 0, ilbc_constants.LPC_FILTERORDER + 1);
        System.arraycopy(fArray, 0, this.prevResidual, 0, this.ULP_inst.blockl);
    }

    void DownSample(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, float[] fArray4) {
        int n3;
        float f;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = n;
        int n8 = 0;
        for (n4 = ilbc_constants.DELAY_DS; n4 < n2; n4 += ilbc_constants.FACTOR_DS) {
            n6 = 0;
            n7 = n + n4;
            n8 = ilbc_constants.FILTERORDER_DS - 2;
            f = 0.0f;
            int n9 = n4 < ilbc_constants.FILTERORDER_DS ? n4 + 1 : ilbc_constants.FILTERORDER_DS;
            for (n3 = 0; n3 < n9; ++n3) {
                f += fArray2[n6] * fArray[n7];
                ++n6;
                --n7;
            }
            for (n3 = n4 + 1; n3 < ilbc_constants.FILTERORDER_DS; ++n3) {
                f += fArray2[n6] * fArray3[n8];
                ++n6;
                --n8;
            }
            fArray4[n5] = f;
            ++n5;
        }
        for (n4 = n2 + ilbc_constants.FACTOR_DS; n4 < n2 + ilbc_constants.DELAY_DS; n4 += ilbc_constants.FACTOR_DS) {
            f = 0.0f;
            if (n4 < n2) {
                n6 = 0;
                n7 = n + n4;
                for (n3 = 0; n3 < ilbc_constants.FILTERORDER_DS; ++n3) {
                    f += fArray2[n6] * fArray4[n5];
                    ++n6;
                    --n5;
                }
            } else {
                n6 = n4 - n2;
                n7 = n + n2 - 1;
                for (n3 = 0; n3 < ilbc_constants.FILTERORDER_DS - (n4 - n2); ++n3) {
                    f += fArray2[n6] * fArray[n7];
                    ++n6;
                    --n7;
                }
            }
            fArray4[n5] = f;
            ++n5;
        }
    }

    public void enh_upsample(float[] fArray, float[] fArray2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray = new int[ilbc_constants.ENH_UPS0];
        int n8 = 2 * n2 + 1;
        if (n8 > n) {
            int n9 = n / 2;
            for (n7 = 0; n7 < ilbc_constants.ENH_UPS0; ++n7) {
                nArray[n7] = n7 * n8 + n2 - n9;
            }
            n2 = n9;
            n8 = 2 * n2 + 1;
        } else {
            for (n7 = 0; n7 < ilbc_constants.ENH_UPS0; ++n7) {
                nArray[n7] = n7 * n8;
            }
        }
        int n10 = 0;
        for (n6 = n2; n6 < n8; ++n6) {
            for (n7 = 0; n7 < ilbc_constants.ENH_UPS0; ++n7) {
                fArray[n10] = 0.0f;
                n5 = nArray[n7];
                n4 = n6;
                for (n3 = 0; n3 <= n6; ++n3) {
                    int n11 = n10;
                    fArray[n11] = fArray[n11] + fArray2[n4] * ilbc_constants.polyphaserTbl[n5];
                    --n4;
                    ++n5;
                }
                ++n10;
            }
        }
        for (n6 = n8; n6 < n; ++n6) {
            for (n7 = 0; n7 < ilbc_constants.ENH_UPS0; ++n7) {
                fArray[n10] = 0.0f;
                n5 = nArray[n7];
                n4 = n6;
                for (n3 = 0; n3 < n8; ++n3) {
                    int n12 = n10;
                    fArray[n12] = fArray[n12] + fArray2[n4] * ilbc_constants.polyphaserTbl[n5];
                    --n4;
                    ++n5;
                }
                ++n10;
            }
        }
        for (int i = 1; i <= n2; ++i) {
            for (n7 = 0; n7 < ilbc_constants.ENH_UPS0; ++n7) {
                fArray[n10] = 0.0f;
                n5 = nArray[n7] + i;
                n4 = n - 1;
                for (n3 = 0; n3 < n8 - i; ++n3) {
                    int n13 = n10;
                    fArray[n13] = fArray[n13] + fArray2[n4] * ilbc_constants.polyphaserTbl[n5];
                    --n4;
                    ++n5;
                }
                ++n10;
            }
        }
    }

    public void enhancer(float[] fArray, int n, float[] fArray2, int n2, int n3, float f, float[] fArray3, float[] fArray4, int n4) {
        float[] fArray5 = new float[(2 * ilbc_constants.ENH_HL + 1) * ilbc_constants.ENH_BLOCKL];
        this.getsseq(fArray5, fArray2, n2, n3, fArray3, fArray4, n4, ilbc_constants.ENH_HL);
        this.smath(fArray, n, fArray5, ilbc_constants.ENH_HL, f);
    }

    int enhancerInterface(float[] fArray, float[] fArray2) {
        int n;
        block15: {
            int n2;
            block14: {
                float f;
                int n3;
                float f2;
                n = 0;
                float[] fArray3 = new float[ilbc_constants.ENH_BLOCKL];
                float[] fArray4 = new float[6];
                float[] fArray5 = new float[(ilbc_constants.ENH_NBLOCKS * ilbc_constants.ENH_BLOCKL + 120) / 2];
                int n4 = ilbc_constants.ENH_NBLOCKS * ilbc_constants.ENH_BLOCKL + 120;
                System.arraycopy(this.enh_buf, this.ULP_inst.blockl, this.enh_buf, 0, ilbc_constants.ENH_BUFL - this.ULP_inst.blockl);
                System.arraycopy(fArray2, 0, this.enh_buf, ilbc_constants.ENH_BUFL - this.ULP_inst.blockl, this.ULP_inst.blockl);
                int n5 = this.ULP_inst.mode == 30 ? ilbc_constants.ENH_BLOCKL : 40;
                int n6 = 0;
                if (this.ULP_inst.mode == 20) {
                    n6 = 1;
                }
                int n7 = 3 - n6;
                System.arraycopy(this.enh_period, n7, this.enh_period, 0, ilbc_constants.ENH_NBLOCKS_TOT - n7);
                System.arraycopy(this.enh_buf, (ilbc_constants.ENH_NBLOCKS_EXTRA + n6) * ilbc_constants.ENH_BLOCKL - 126, fArray4, 0, 6);
                this.DownSample(this.enh_buf, (ilbc_constants.ENH_NBLOCKS_EXTRA + n6) * ilbc_constants.ENH_BLOCKL - 120, ilbc_constants.lpFilt_coefsTbl, n4 - n6 * ilbc_constants.ENH_BLOCKL, fArray4, fArray5);
                for (n2 = 0; n2 < ilbc_constants.ENH_NBLOCKS - n6; ++n2) {
                    n = 10;
                    f2 = this.xCorrCoef(fArray5, 60 + n2 * ilbc_constants.ENH_BLOCKL_HALF, fArray5, 60 + n2 * ilbc_constants.ENH_BLOCKL_HALF - n, ilbc_constants.ENH_BLOCKL_HALF);
                    for (n3 = 11; n3 < 60; ++n3) {
                        f = this.xCorrCoef(fArray5, 60 + n2 * ilbc_constants.ENH_BLOCKL_HALF, fArray5, 60 + n2 * ilbc_constants.ENH_BLOCKL_HALF - n3, ilbc_constants.ENH_BLOCKL_HALF);
                        if (!(f > f2)) continue;
                        f2 = f;
                        n = n3;
                    }
                    this.enh_period[n2 + ilbc_constants.ENH_NBLOCKS_EXTRA + n6] = (float)n * 2.0f;
                }
                if (this.prev_enh_pl == 1) {
                    int n8;
                    int n9 = (int)this.enh_period[ilbc_constants.ENH_NBLOCKS_EXTRA + n6];
                    n = n9 - 1;
                    f2 = this.xCorrCoef(fArray2, 0, fArray2, n, n5);
                    for (n3 = n9; n3 <= n9 + 1; ++n3) {
                        f = this.xCorrCoef(fArray2, 0, fArray2, n3, n5);
                        if (!(f > f2)) continue;
                        f2 = f;
                        n = n3;
                    }
                    this.enh_period[ilbc_constants.ENH_NBLOCKS_EXTRA + n6 - 1] = n;
                    int n10 = n - 1;
                    int n11 = n5 - 1;
                    int n12 = n > n5 ? n5 : n;
                    for (n8 = n12; n8 > 0; --n8) {
                        fArray3[n11] = fArray2[n10];
                        --n11;
                        --n10;
                    }
                    int n13 = ilbc_constants.ENH_BUFL - 1 - this.ULP_inst.blockl;
                    for (n8 = n5 - 1 - n; n8 >= 0; --n8) {
                        fArray3[n11] = this.enh_buf[n13];
                        --n11;
                        --n13;
                    }
                    float f3 = 0.0f;
                    float f4 = 0.0f;
                    for (n7 = 0; n7 < n5; ++n7) {
                        f3 += this.enh_buf[ilbc_constants.ENH_BUFL - 1 - this.ULP_inst.blockl - n7] * this.enh_buf[ilbc_constants.ENH_BUFL - 1 - this.ULP_inst.blockl - n7];
                        f4 += fArray3[n7] * fArray3[n7];
                    }
                    if ((f4 = (float)Math.sqrt(f4 / (float)n5)) > 2.0f * (f3 = (float)Math.sqrt(f3 / (float)n5)) && (double)f4 > 0.0) {
                        n7 = 0;
                        while (n7 < n5 - 10) {
                            int n14 = n7++;
                            fArray3[n14] = fArray3[n14] * (2.0f * f3 / f4);
                        }
                        for (n7 = n5 - 10; n7 < n5; ++n7) {
                            int n15 = n7;
                            fArray3[n15] = fArray3[n15] * ((float)(n7 - n5 + 10) * (1.0f - 2.0f * f3 / f4) / 10.0f + 2.0f * f3 / f4);
                        }
                    }
                    n11 = ilbc_constants.ENH_BUFL - 1 - this.ULP_inst.blockl;
                    for (n7 = 0; n7 < n5; ++n7) {
                        f4 = (float)(n7 + 1) / (float)(n5 + 1);
                        int n16 = n11;
                        this.enh_buf[n16] = this.enh_buf[n16] * f4;
                        int n17 = n11--;
                        this.enh_buf[n17] = this.enh_buf[n17] + (1.0f - f4) * fArray3[n5 - 1 - n7];
                    }
                }
                if (this.ULP_inst.mode != 20) break block14;
                for (n2 = 0; n2 < 2; ++n2) {
                    this.enhancer(fArray, n2 * ilbc_constants.ENH_BLOCKL, this.enh_buf, ilbc_constants.ENH_BUFL, (5 + n2) * ilbc_constants.ENH_BLOCKL + 40, ilbc_constants.ENH_ALPHA0, this.enh_period, ilbc_constants.enh_plocsTbl, ilbc_constants.ENH_NBLOCKS_TOT);
                }
                break block15;
            }
            if (this.ULP_inst.mode != 30) break block15;
            for (n2 = 0; n2 < 3; ++n2) {
                this.enhancer(fArray, n2 * ilbc_constants.ENH_BLOCKL, this.enh_buf, ilbc_constants.ENH_BUFL, (4 + n2) * ilbc_constants.ENH_BLOCKL, ilbc_constants.ENH_ALPHA0, this.enh_period, ilbc_constants.enh_plocsTbl, ilbc_constants.ENH_NBLOCKS_TOT);
            }
        }
        return n * 2;
    }

    public void getsseq(float[] fArray, float[] fArray2, int n, int n2, float[] fArray3, float[] fArray4, int n3, int n4) {
        int n5;
        int n6;
        float[] fArray5 = new float[2 * ilbc_constants.ENH_HL + 1];
        int[] nArray = new int[2 * ilbc_constants.ENH_HL + 1];
        float[] fArray6 = new float[ilbc_constants.ENH_PLOCSL];
        int n7 = n2 + ilbc_constants.ENH_BLOCKL - 1;
        nArray[n4] = this.NearestNeighbor(fArray4, 0.5f * (float)(n2 + n7), n3);
        fArray5[n4] = n2;
        int n8 = ilbc_constants.ENH_BLOCKL * n4;
        System.arraycopy(fArray2, n2, fArray, n8, ilbc_constants.ENH_BLOCKL);
        for (n6 = n4 - 1; n6 >= 0; --n6) {
            fArray5[n6] = fArray5[n6 + 1] - fArray3[nArray[n6 + 1]];
            nArray[n6] = this.NearestNeighbor(fArray4, fArray5[n6] + (float)ilbc_constants.ENH_BLOCKL_HALF - fArray3[nArray[n6 + 1]], n3);
            if (fArray5[n6] - (float)ilbc_constants.ENH_OVERHANG >= 0.0f) {
                fArray5[n6] = this.refiner(fArray, n6 * ilbc_constants.ENH_BLOCKL, fArray2, n, n2, fArray5[n6], fArray3[nArray[n6 + 1]]);
                continue;
            }
            n8 = n6 * ilbc_constants.ENH_BLOCKL;
            for (n5 = 0; n5 < ilbc_constants.ENH_BLOCKL; ++n5) {
                fArray[n8 + n5] = 0.0f;
            }
        }
        for (int i = 0; i < n3; ++i) {
            fArray6[i] = fArray4[i] - fArray3[i];
        }
        for (n6 = n4 + 1; n6 <= 2 * n4; ++n6) {
            nArray[n6] = this.NearestNeighbor(fArray6, fArray5[n6 - 1] + (float)ilbc_constants.ENH_BLOCKL_HALF, n3);
            fArray5[n6] = fArray5[n6 - 1] + fArray3[nArray[n6]];
            if (fArray5[n6] + (float)ilbc_constants.ENH_BLOCKL + (float)ilbc_constants.ENH_OVERHANG < (float)n) {
                fArray5[n6] = this.refiner(fArray, n6 * ilbc_constants.ENH_BLOCKL, fArray2, n, n2, fArray5[n6], fArray3[nArray[n6]]);
                continue;
            }
            n8 = n6 * ilbc_constants.ENH_BLOCKL;
            for (n5 = 0; n5 < ilbc_constants.ENH_BLOCKL; ++n5) {
                fArray[n8 + n5] = 0.0f;
            }
        }
    }

    public void hpOutput(float[] fArray, int n, float[] fArray2, float[] fArray3) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            fArray2[n4] = ilbc_constants.hpo_zero_coefsTbl[0] * fArray[n3];
            int n5 = n4;
            fArray2[n5] = fArray2[n5] + ilbc_constants.hpo_zero_coefsTbl[1] * fArray3[0];
            int n6 = n4++;
            fArray2[n6] = fArray2[n6] + ilbc_constants.hpo_zero_coefsTbl[2] * fArray3[1];
            fArray3[1] = fArray3[0];
            fArray3[0] = fArray[n3];
            ++n3;
        }
        n4 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            int n7 = n4;
            fArray2[n7] = fArray2[n7] - ilbc_constants.hpo_pole_coefsTbl[1] * fArray3[2];
            int n8 = n4;
            fArray2[n8] = fArray2[n8] - ilbc_constants.hpo_pole_coefsTbl[2] * fArray3[3];
            fArray3[3] = fArray3[2];
            fArray3[2] = fArray2[n4];
            ++n4;
        }
    }

    void iLBC_decode(float[] fArray, bitstream bitstream2, int n) {
        int n2;
        int n3;
        float[] fArray2 = new float[ilbc_constants.BLOCKL_MAX];
        float[] fArray3 = new float[ilbc_constants.LPC_FILTERORDER * ilbc_constants.LPC_N_MAX];
        float[] fArray4 = new float[ilbc_constants.BLOCKL_MAX];
        float[] fArray5 = new float[ilbc_constants.LPC_FILTERORDER + 1];
        float[] fArray6 = new float[ilbc_constants.BLOCKL_MAX];
        float[] fArray7 = new float[ilbc_constants.LPC_FILTERORDER + 1];
        int[] nArray = new int[ilbc_constants.STATE_LEN];
        int[] nArray2 = new int[ilbc_constants.NASUB_MAX * ilbc_constants.CB_NSTAGES];
        int[] nArray3 = new int[ilbc_constants.CB_NSTAGES];
        int[] nArray4 = new int[ilbc_constants.CB_NSTAGES * ilbc_constants.NASUB_MAX];
        int[] nArray5 = new int[ilbc_constants.CB_NSTAGES];
        int[] nArray6 = new int[ilbc_constants.LSF_NSPLIT * ilbc_constants.LPC_N_MAX];
        float[] fArray8 = new float[(ilbc_constants.LPC_FILTERORDER + 1) * ilbc_constants.NSUB_MAX];
        float[] fArray9 = new float[ilbc_constants.NSUB_MAX * (ilbc_constants.LPC_FILTERORDER + 1)];
        float[] fArray10 = new float[ilbc_constants.BLOCKL_MAX];
        if (n > 0) {
            int n4;
            boolean bl = false;
            for (n4 = 0; n4 < ilbc_constants.LSF_NSPLIT * ilbc_constants.LPC_N_MAX; ++n4) {
                nArray6[n4] = 0;
            }
            n3 = 0;
            int n5 = 0;
            int n6 = 0;
            for (n4 = 0; n4 < this.ULP_inst.state_short_len; ++n4) {
                nArray[n4] = 0;
            }
            for (n4 = 0; n4 < ilbc_constants.CB_NSTAGES; ++n4) {
                nArray5[n4] = 0;
            }
            for (n4 = 0; n4 < ilbc_constants.CB_NSTAGES; ++n4) {
                nArray3[n4] = 0;
            }
            for (n2 = 0; n2 < this.ULP_inst.nasub; ++n2) {
                for (n4 = 0; n4 < ilbc_constants.CB_NSTAGES; ++n4) {
                    nArray4[n2 * ilbc_constants.CB_NSTAGES + n4] = 0;
                }
            }
            for (n2 = 0; n2 < this.ULP_inst.nasub; ++n2) {
                for (n4 = 0; n4 < ilbc_constants.CB_NSTAGES; ++n4) {
                    nArray2[n2 * ilbc_constants.CB_NSTAGES + n4] = 0;
                }
            }
            for (int i = 0; i < 3; ++i) {
                int n7;
                for (n4 = 0; n4 < ilbc_constants.LSF_NSPLIT * this.ULP_inst.lpc_n; ++n4) {
                    n7 = bitstream2.unpack(this.ULP_inst.lsf_bits[n4][i]);
                    nArray6[n4] = bitstream2.packcombine(nArray6[n4], n7, this.ULP_inst.lsf_bits[n4][i]);
                }
                n7 = bitstream2.unpack(this.ULP_inst.start_bits[i]);
                n3 = bitstream2.packcombine(n3, n7, this.ULP_inst.start_bits[i]);
                n7 = bitstream2.unpack(this.ULP_inst.startfirst_bits[i]);
                n5 = bitstream2.packcombine(n5, n7, this.ULP_inst.startfirst_bits[i]);
                n7 = bitstream2.unpack(this.ULP_inst.scale_bits[i]);
                n6 = bitstream2.packcombine(n6, n7, this.ULP_inst.scale_bits[i]);
                for (n4 = 0; n4 < this.ULP_inst.state_short_len; ++n4) {
                    n7 = bitstream2.unpack(this.ULP_inst.state_bits[i]);
                    nArray[n4] = bitstream2.packcombine(nArray[n4], n7, this.ULP_inst.state_bits[i]);
                }
                for (n4 = 0; n4 < ilbc_constants.CB_NSTAGES; ++n4) {
                    n7 = bitstream2.unpack(this.ULP_inst.extra_cb_index[n4][i]);
                    nArray5[n4] = bitstream2.packcombine(nArray5[n4], n7, this.ULP_inst.extra_cb_index[n4][i]);
                }
                for (n4 = 0; n4 < ilbc_constants.CB_NSTAGES; ++n4) {
                    n7 = bitstream2.unpack(this.ULP_inst.extra_cb_gain[n4][i]);
                    nArray3[n4] = bitstream2.packcombine(nArray3[n4], n7, this.ULP_inst.extra_cb_gain[n4][i]);
                }
                for (n2 = 0; n2 < this.ULP_inst.nasub; ++n2) {
                    for (n4 = 0; n4 < ilbc_constants.CB_NSTAGES; ++n4) {
                        n7 = bitstream2.unpack(this.ULP_inst.cb_index[n2][n4][i]);
                        nArray4[n2 * ilbc_constants.CB_NSTAGES + n4] = bitstream2.packcombine(nArray4[n2 * ilbc_constants.CB_NSTAGES + n4], n7, this.ULP_inst.cb_index[n2][n4][i]);
                    }
                }
                for (n2 = 0; n2 < this.ULP_inst.nasub; ++n2) {
                    for (n4 = 0; n4 < ilbc_constants.CB_NSTAGES; ++n4) {
                        n7 = bitstream2.unpack(this.ULP_inst.cb_gain[n2][n4][i]);
                        nArray2[n2 * ilbc_constants.CB_NSTAGES + n4] = bitstream2.packcombine(nArray2[n2 * ilbc_constants.CB_NSTAGES + n4], n7, this.ULP_inst.cb_gain[n2][n4][i]);
                    }
                }
            }
            int n8 = bitstream2.unpack(1);
            if (n3 < 1) {
                n = 0;
            }
            if (this.ULP_inst.mode == 20 && n3 > 3) {
                n = 0;
            }
            if (this.ULP_inst.mode == 30 && n3 > 5) {
                n = 0;
            }
            if (n8 == 1) {
                n = 0;
            }
            if (n == 1) {
                this.index_conv_dec(nArray4);
                this.SimplelsfDEQ(fArray3, nArray6, this.ULP_inst.lpc_n);
                int n9 = ilbc_common.LSF_check(fArray3, ilbc_constants.LPC_FILTERORDER, this.ULP_inst.lpc_n);
                this.DecoderInterpolateLSF(fArray9, fArray8, fArray3, ilbc_constants.LPC_FILTERORDER);
                this.Decode(fArray10, n3, n6, nArray, fArray9, nArray4, nArray2, nArray5, nArray3, n5);
                this.doThePLC(fArray4, fArray5, 0, fArray10, fArray9, (ilbc_constants.LPC_FILTERORDER + 1) * (this.ULP_inst.nsub - 1), this.last_lag);
                System.arraycopy(fArray4, 0, fArray10, 0, this.ULP_inst.blockl);
            }
        }
        if (n == 0) {
            int n10;
            for (n10 = 0; n10 < ilbc_constants.BLOCKL_MAX; ++n10) {
                fArray6[n10] = 0.0f;
            }
            fArray7[0] = 1.0f;
            for (n10 = 0; n10 < ilbc_constants.LPC_FILTERORDER; ++n10) {
                fArray7[n10 + 1] = 0.0f;
            }
            n3 = 0;
            this.doThePLC(fArray4, fArray5, 1, fArray6, fArray7, 0, this.last_lag);
            System.arraycopy(fArray4, 0, fArray10, 0, this.ULP_inst.blockl);
            int n11 = ilbc_constants.LPC_FILTERORDER + 1;
            for (n2 = 0; n2 < this.ULP_inst.nsub; ++n2) {
                System.arraycopy(fArray5, 0, fArray9, n2 * n11, n11);
            }
        }
        if (this.use_enhancer == 1) {
            this.last_lag = this.enhancerInterface(fArray2, fArray10);
            if (this.ULP_inst.mode == 20) {
                n2 = 0;
                this.syntFilter(fArray2, n2 * ilbc_constants.SUBL, this.old_syntdenum, (n2 + this.ULP_inst.nsub - 1) * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
                for (n2 = 1; n2 < this.ULP_inst.nsub; ++n2) {
                    this.syntFilter(fArray2, n2 * ilbc_constants.SUBL, fArray9, (n2 - 1) * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
                }
            } else if (this.ULP_inst.mode == 30) {
                for (n2 = 0; n2 < 2; ++n2) {
                    this.syntFilter(fArray2, n2 * ilbc_constants.SUBL, this.old_syntdenum, (n2 + this.ULP_inst.nsub - 2) * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
                }
                for (n2 = 2; n2 < this.ULP_inst.nsub; ++n2) {
                    this.syntFilter(fArray2, n2 * ilbc_constants.SUBL, fArray9, (n2 - 2) * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
                }
            }
        } else {
            int n12 = 20;
            float f = this.xCorrCoef(fArray10, ilbc_constants.BLOCKL_MAX - ilbc_constants.ENH_BLOCKL, fArray10, ilbc_constants.BLOCKL_MAX - ilbc_constants.ENH_BLOCKL - n12, ilbc_constants.ENH_BLOCKL);
            for (int i = 21; i < 120; ++i) {
                float f2 = this.xCorrCoef(fArray10, ilbc_constants.BLOCKL_MAX - ilbc_constants.ENH_BLOCKL, fArray10, ilbc_constants.BLOCKL_MAX - ilbc_constants.ENH_BLOCKL - i, ilbc_constants.ENH_BLOCKL);
                if (!(f2 > f)) continue;
                f = f2;
                n12 = i;
            }
            this.last_lag = n12;
            System.arraycopy(fArray10, 0, fArray2, 0, this.ULP_inst.blockl);
            for (n2 = 0; n2 < this.ULP_inst.nsub; ++n2) {
                this.syntFilter(fArray2, n2 * ilbc_constants.SUBL, fArray9, n2 * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
            }
        }
        this.hpOutput(fArray2, this.ULP_inst.blockl, fArray, this.hpomem);
        System.arraycopy(fArray9, 0, this.old_syntdenum, 0, this.ULP_inst.nsub * (ilbc_constants.LPC_FILTERORDER + 1));
        this.prev_enh_pl = 0;
        if (n == 0) {
            this.prev_enh_pl = 1;
        }
    }

    public void index_conv_dec(int[] nArray) {
        for (int i = 1; i < ilbc_constants.CB_NSTAGES; ++i) {
            if (nArray[i] >= 44 && nArray[i] < 108) {
                int n = i;
                nArray[n] = nArray[n] + 64;
                continue;
            }
            if (nArray[i] < 108 || nArray[i] >= 128) continue;
            int n = i;
            nArray[n] = nArray[n] + 128;
        }
    }

    public void LSFinterpolate2a_dec(float[] fArray, float[] fArray2, float[] fArray3, int n, float f, int n2) {
        float[] fArray4 = new float[ilbc_constants.LPC_FILTERORDER];
        ilbc_common.interpolate(fArray4, fArray2, fArray3, n, f, n2);
        ilbc_common.lsf2a(fArray, fArray4);
    }

    public void mycorr1(float[] fArray, int n, float[] fArray2, int n2, int n3, float[] fArray3, int n4, int n5) {
        for (int i = 0; i <= n3 - n5; ++i) {
            if (n + i < fArray.length) {
                fArray[n + i] = 0.0f;
            }
            for (int j = 0; j < n5; ++j) {
                int n6 = n + i;
                fArray[n6] = fArray[n6] + fArray2[n2 + i + j] * fArray3[n4 + j];
            }
        }
    }

    public int NearestNeighbor(float[] fArray, float f, int n) {
        float f2 = fArray[0] - f;
        float f3 = f2 * f2;
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            f2 = fArray[i] - f;
            if (!((f2 *= f2) < f3)) continue;
            f3 = f2;
            n2 = i;
        }
        return n2;
    }

    public float refiner(float[] fArray, int n, float[] fArray2, int n2, int n3, float f, float f2) {
        int n4;
        int n5;
        float[] fArray3 = new float[ilbc_constants.ENH_VECTL];
        float[] fArray4 = new float[ilbc_constants.ENH_CORRDIM];
        float[] fArray5 = new float[ilbc_constants.ENH_CORRDIM * ilbc_constants.ENH_UPS0];
        float f3 = 0.0f;
        int n6 = (int)((double)f - 0.5);
        int n7 = n6 - ilbc_constants.ENH_SLOP;
        if (n7 < 0) {
            n7 = 0;
        }
        if ((n5 = n6 + ilbc_constants.ENH_SLOP) + ilbc_constants.ENH_BLOCKL >= n2) {
            n5 = n2 - ilbc_constants.ENH_BLOCKL - 1;
        }
        int n8 = n5 - n7 + 1;
        this.mycorr1(fArray4, 0, fArray2, n7, n8 + ilbc_constants.ENH_BLOCKL - 1, fArray2, n3, ilbc_constants.ENH_BLOCKL);
        this.enh_upsample(fArray5, fArray4, n8, ilbc_constants.ENH_FL0);
        int n9 = 0;
        float f4 = fArray5[0];
        for (int i = 1; i < ilbc_constants.ENH_UPS0 * n8; ++i) {
            if (!(fArray5[i] > f4)) continue;
            n9 = i;
            f4 = fArray5[i];
        }
        f3 = (float)n7 + (float)n9 / (float)ilbc_constants.ENH_UPS0 + 1.0f;
        int n10 = n9 / ilbc_constants.ENH_UPS0;
        if (n9 > n10 * ilbc_constants.ENH_UPS0) {
            ++n10;
        }
        if ((n4 = n7 + n10 - ilbc_constants.ENH_FL0) < 0) {
            for (int i = 0; i < -n4; ++i) {
                fArray3[i] = 0.0f;
            }
            System.arraycopy(fArray2, 0, fArray3, -n4, ilbc_constants.ENH_VECTL + n4);
        } else {
            int n11 = n4 + ilbc_constants.ENH_VECTL;
            if (n11 > n2) {
                System.arraycopy(fArray2, n4, fArray3, 0, ilbc_constants.ENH_VECTL - (n11 - n2));
                for (int i = 0; i < n11 - n2; ++i) {
                    fArray3[ilbc_constants.ENH_VECTL - (n11 - n2) + i] = 0.0f;
                }
            } else {
                System.arraycopy(fArray2, n4, fArray3, 0, ilbc_constants.ENH_VECTL);
            }
        }
        int n12 = n10 * ilbc_constants.ENH_UPS0 - n9;
        this.mycorr1(fArray, n, fArray3, 0, ilbc_constants.ENH_VECTL, ilbc_constants.polyphaserTbl, (2 * ilbc_constants.ENH_FL0 + 1) * n12, 2 * ilbc_constants.ENH_FL0 + 1);
        return f3;
    }

    void SimplelsfDEQ(float[] fArray, int[] nArray, int n) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < ilbc_constants.LSF_NSPLIT; ++n3) {
            for (n2 = 0; n2 < ilbc_constants.dim_lsfCbTbl[n3]; ++n2) {
                fArray[n4 + n2] = ilbc_constants.lsfCbTbl[n5 + (int)((long)nArray[n3] * (long)ilbc_constants.dim_lsfCbTbl[n3] + (long)n2)];
            }
            n4 += ilbc_constants.dim_lsfCbTbl[n3];
            n5 += ilbc_constants.size_lsfCbTbl[n3] * ilbc_constants.dim_lsfCbTbl[n3];
        }
        if (n > 1) {
            n4 = 0;
            n5 = 0;
            for (n3 = 0; n3 < ilbc_constants.LSF_NSPLIT; ++n3) {
                for (n2 = 0; n2 < ilbc_constants.dim_lsfCbTbl[n3]; ++n2) {
                    fArray[ilbc_constants.LPC_FILTERORDER + n4 + n2] = ilbc_constants.lsfCbTbl[n5 + (int)((long)nArray[ilbc_constants.LSF_NSPLIT + n3] * (long)ilbc_constants.dim_lsfCbTbl[n3]) + n2];
                }
                n4 += ilbc_constants.dim_lsfCbTbl[n3];
                n5 += ilbc_constants.size_lsfCbTbl[n3] * ilbc_constants.dim_lsfCbTbl[n3];
            }
        }
    }

    public void smath(float[] fArray, int n, float[] fArray2, int n2, float f) {
        int n3;
        int n4;
        int n5;
        float[] fArray3 = new float[ilbc_constants.BLOCKL_MAX];
        float[] fArray4 = new float[2 * ilbc_constants.ENH_HL + 1];
        for (n5 = 1; n5 <= 2 * n2 + 1; ++n5) {
            fArray4[n5 - 1] = 0.5f * (1.0f - (float)Math.cos(2.0f * ilbc_constants.PI * (float)n5 / (float)(2 * n2 + 2)));
        }
        fArray4[n2] = 0.0f;
        for (n5 = 0; n5 < ilbc_constants.ENH_BLOCKL; ++n5) {
            fArray3[n5] = fArray2[n5] * fArray4[0];
        }
        for (n4 = 1; n4 < n2; ++n4) {
            n3 = n4 * ilbc_constants.ENH_BLOCKL;
            for (n5 = 0; n5 < ilbc_constants.ENH_BLOCKL; ++n5) {
                int n6 = n5;
                fArray3[n6] = fArray3[n6] + fArray2[n3 + n5] * fArray4[n4];
            }
        }
        for (n4 = n2 + 1; n4 <= 2 * n2; ++n4) {
            n3 = n4 * ilbc_constants.ENH_BLOCKL;
            for (n5 = 0; n5 < ilbc_constants.ENH_BLOCKL; ++n5) {
                int n7 = n5;
                fArray3[n7] = fArray3[n7] + fArray2[n3 + n5] * fArray4[n4];
            }
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        n3 = n2 * ilbc_constants.ENH_BLOCKL;
        for (n5 = 0; n5 < ilbc_constants.ENH_BLOCKL; ++n5) {
            f4 += fArray2[n3 + n5] * fArray2[n3 + n5];
            f2 += fArray3[n5] * fArray3[n5];
            f3 += fArray3[n5] * fArray2[n3 + n5];
        }
        if (Math.abs(f2) < 1.0f) {
            f2 = 1.0f;
        }
        float f5 = (float)Math.sqrt(f4 / f2);
        float f6 = 0.0f;
        n3 = n2 * ilbc_constants.ENH_BLOCKL;
        for (n5 = 0; n5 < ilbc_constants.ENH_BLOCKL; ++n5) {
            fArray[n + n5] = f5 * fArray3[n5];
            float f7 = fArray2[n3 + n5] - fArray[n + n5];
            f6 += f7 * f7;
        }
        if (f6 > f * f4) {
            float f8;
            float f9;
            float f10;
            if (f4 < 1.0f) {
                f4 = 1.0f;
            }
            if ((f10 = (f2 * f4 - f3 * f3) / (f4 * f4)) > 1.0E-4f) {
                f9 = (float)Math.sqrt((f - f * f / 4.0f) / f10);
                f8 = -f / 2.0f - f9 * f3 / f4;
                f8 += 1.0f;
            } else {
                f9 = 0.0f;
                f8 = 1.0f;
            }
            n3 = n2 * ilbc_constants.ENH_BLOCKL;
            for (n5 = 0; n5 < ilbc_constants.ENH_BLOCKL; ++n5) {
                fArray[n + n5] = f9 * fArray3[n5] + f8 * fArray2[n3 + n5];
            }
        }
    }

    void syntFilter(float[] fArray, int n, float[] fArray2, int n2, int n3, float[] fArray3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n;
        for (n7 = 0; n7 < ilbc_constants.LPC_FILTERORDER; ++n7) {
            n6 = n + n7 - 1;
            n5 = n2 + 1;
            int n9 = ilbc_constants.LPC_FILTERORDER - 1;
            for (n4 = 1; n4 <= n7; ++n4) {
                int n10 = n8;
                fArray[n10] = fArray[n10] - fArray2[n5] * fArray[n6];
                ++n5;
                --n6;
            }
            for (n4 = n7 + 1; n4 < ilbc_constants.LPC_FILTERORDER + 1; ++n4) {
                int n11 = n8;
                fArray[n11] = fArray[n11] - fArray2[n5] * fArray3[n9];
                ++n5;
                --n9;
            }
            ++n8;
        }
        for (n7 = ilbc_constants.LPC_FILTERORDER; n7 < n3; ++n7) {
            n6 = n + n7 - 1;
            n5 = n2 + 1;
            for (n4 = 1; n4 < ilbc_constants.LPC_FILTERORDER + 1; ++n4) {
                int n12 = n8;
                fArray[n12] = fArray[n12] - fArray2[n5] * fArray[n6];
                ++n5;
                --n6;
            }
            ++n8;
        }
        System.arraycopy(fArray, n + n3 - ilbc_constants.LPC_FILTERORDER, fArray3, 0, ilbc_constants.LPC_FILTERORDER);
    }

    public float xCorrCoef(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n3; ++i) {
            f += fArray[n + i] * fArray2[n2 + i];
            f2 += fArray2[n2 + i] * fArray2[n2 + i];
        }
        if (f > 0.0f) {
            return f * f / f2;
        }
        return 0.0f;
    }
}

