/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.transform;

import java.util.LinkedList;
import org.jitsi.impl.neomedia.transform.AbsSendTimeEngine;
import org.jitsi.impl.neomedia.transform.REDFilterTransformEngine;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.TransformEngineChain;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.Transformer;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.rewriting.SsrcRewritingEngine;
import org.jitsi.videobridge.rtcp.NACKHandler;
import org.jitsi.videobridge.rtcp.NACKNotifier;
import org.jitsi.videobridge.transform.CachingTransformer;
import org.jitsi.videobridge.transform.RTCPTransformEngine;
import org.jitsi.videobridge.transform.RawPacketCache;
import org.jitsi.videobridge.transform.RetransmissionRequester;

public class RtpChannelTransformEngine
extends TransformEngineChain {
    private static final byte RED_PAYLOAD_TYPE = 116;
    private static final String DISABLE_NACK_TERMINATION_PNAME = "org.jitsi.videobridge.DISABLE_NACK_TERMINATION";
    public static final String DISABLE_RETRANSMISSION_REQUESTS = "org.jitsi.videobridge.DISABLE_RETRANSMISSION_REQUESTS";
    private static final Logger logger = Logger.getLogger(RtpChannelTransformEngine.class);
    private final RtpChannel channel;
    private REDFilterTransformEngine redFilter;
    private CachingTransformer cache;
    private RTCPTransformEngine rtcpTransformEngine;
    private NACKNotifier nackNotifier;
    private AbsSendTimeEngine absSendTime;
    private RetransmissionRequester retransmissionRequester;
    private SsrcRewritingEngine ssrcRewritingEngine;

    public RtpChannelTransformEngine(RtpChannel channel) {
        this.channel = channel;
        this.engineChain = this.createChain();
    }

    private TransformEngine[] createChain() {
        Conference conference = this.channel.getContent().getConference();
        ConfigurationService cfg = conference.getVideobridge().getConfigurationService();
        LinkedList<Object> transformerList = new LinkedList<Object>();
        if (cfg == null || !cfg.getBoolean(DISABLE_RETRANSMISSION_REQUESTS, false)) {
            this.retransmissionRequester = new RetransmissionRequester(this.channel);
            transformerList.add((Object)this.retransmissionRequester);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Enabling retransmission requests for channel" + this.channel.getID()));
            }
        }
        this.redFilter = new REDFilterTransformEngine(116);
        transformerList.add(this.redFilter);
        this.absSendTime = new AbsSendTimeEngine();
        transformerList.add(this.absSendTime);
        boolean enableNackTermination = true;
        if (conference != null && cfg != null) {
            boolean bl = enableNackTermination = !cfg.getBoolean(DISABLE_NACK_TERMINATION_PNAME, false);
        }
        if (enableNackTermination && this.channel instanceof NACKHandler) {
            logger.info((Object)("Enabling NACK termination for channel " + this.channel.getID()));
            this.cache = new CachingTransformer();
            transformerList.add(this.cache);
            this.nackNotifier = new NACKNotifier((NACKHandler)((Object)this.channel));
            this.rtcpTransformEngine = new RTCPTransformEngine(new Transformer[]{this.nackNotifier});
            transformerList.add((Object)this.rtcpTransformEngine);
        }
        if (this.channel instanceof VideoChannel) {
            VideoChannel videoChannel = (VideoChannel)this.channel;
            this.ssrcRewritingEngine = new SsrcRewritingEngine(videoChannel);
            transformerList.add(this.ssrcRewritingEngine);
        }
        return transformerList.toArray(new TransformEngine[transformerList.size()]);
    }

    public void enableAbsSendTime(int extensionID) {
        if (this.absSendTime != null) {
            this.absSendTime.setExtensionID(extensionID);
        }
    }

    public void enableREDFilter(boolean enabled) {
        if (this.redFilter != null) {
            this.redFilter.setEnabled(enabled);
        }
    }

    public RawPacketCache getCache() {
        return this.cache;
    }

    public void enableSsrcRewriting(boolean enabled) {
        if (this.ssrcRewritingEngine != null) {
            this.ssrcRewritingEngine.setEnabled(enabled);
        }
    }

    public boolean retransmissionsRequestsEnabled() {
        return this.retransmissionRequester != null;
    }

    public boolean isSsrcRewritingEnabled() {
        return this.ssrcRewritingEngine.isEnabled();
    }
}

