/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import org.ice4j.StunException;
import org.ice4j.attribute.Attribute;

public class ConnectionIdAttribute
extends Attribute {
    public static final String NAME = "CONNECTION-ID";
    public static final char DATA_LENGTH = '\u0004';
    private int connectionIdValue;

    protected ConnectionIdAttribute() {
        super('*');
    }

    public char getDataLength() {
        return '\u0004';
    }

    public String getName() {
        return NAME;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConnectionIdAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ConnectionIdAttribute att = (ConnectionIdAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.connectionIdValue == this.connectionIdValue;
    }

    public byte[] encode() {
        byte[] binValue = new byte[]{(byte)(this.getAttributeType() >> 8), (byte)(this.getAttributeType() & 0xFF), (byte)(this.getDataLength() >> 8), (byte)(this.getDataLength() & 0xFF), (byte)(this.connectionIdValue >> 24), (byte)((this.connectionIdValue & 0xFF0000) >> 16), (byte)((this.connectionIdValue & 0xFF00) >> 8), (byte)(this.connectionIdValue & 0xFF)};
        return binValue;
    }

    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        if (length != '\u0004') {
            throw new StunException("length invalid: " + length);
        }
        this.connectionIdValue = attributeValue[offset] & 0xFF;
        this.connectionIdValue = this.connectionIdValue << 8 | attributeValue[offset + '\u0001'] & 0xFF;
        this.connectionIdValue = this.connectionIdValue << 8 | attributeValue[offset + 2] & 0xFF;
        this.connectionIdValue = this.connectionIdValue << 8 | attributeValue[offset + 3] & 0xFF;
    }

    public int getConnectionIdValue() {
        return this.connectionIdValue;
    }

    public void setConnectionIdValue(int connectionIdValue) {
        this.connectionIdValue = connectionIdValue;
    }
}

