/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.Buffer;
import org.mortbay.io.WriterOutputStream;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URIUtil;

public class ResourceHandler
extends AbstractHandler {
    Resource _baseResource;
    String[] _welcomeFiles = new String[]{"index.html"};
    MimeTypes _mimeTypes = new MimeTypes();

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public void setBaseResource(Resource base) {
        this._baseResource = base;
    }

    public void setResourceBase(String resourceBase) {
        try {
            this.setBaseResource(Resource.newResource(resourceBase));
        }
        catch (Exception e) {
            Log.warn((Throwable)e);
            throw new IllegalArgumentException(resourceBase);
        }
    }

    public Resource getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        if (this._baseResource == null) {
            return null;
        }
        try {
            path = URIUtil.canonicalPath((String)path);
            Resource resource = this._baseResource.addPath(path);
            return resource;
        }
        catch (Exception e) {
            Log.ignore((Throwable)e);
            return null;
        }
    }

    protected Resource getResource(HttpServletRequest request) throws MalformedURLException {
        String path_info = request.getPathInfo();
        if (path_info == null) {
            return null;
        }
        return this.getResource(path_info);
    }

    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    public void setWelcomeFiles(String[] welcomeFiles) {
        this._welcomeFiles = welcomeFiles;
    }

    protected Resource getWelcome(Resource directory) throws MalformedURLException, IOException {
        for (int i = 0; i < this._welcomeFiles.length; ++i) {
            Resource welcome = directory.addPath(this._welcomeFiles[i]);
            if (!welcome.exists() || welcome.isDirectory()) continue;
            return welcome;
        }
        return null;
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        long length;
        Buffer mime;
        long last_modified;
        Request base_request;
        Request request2 = base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        if (base_request.isHandled() || !request.getMethod().equals("GET")) {
            return;
        }
        Resource resource = this.getResource(request);
        if (resource == null || !resource.exists()) {
            return;
        }
        base_request.setHandled(true);
        if (resource.isDirectory()) {
            if (!request.getPathInfo().endsWith("/")) {
                response.sendRedirect(request.getRequestURI() + "/");
                return;
            }
            if ((resource = this.getWelcome(resource)) == null || !resource.exists() || resource.isDirectory()) {
                response.sendError(403);
                return;
            }
        }
        if ((last_modified = resource.lastModified()) > 0L) {
            long if_modified = request.getDateHeader("If-Modified-Since");
            if (if_modified > 0L && last_modified / 1000L <= if_modified / 1000L) {
                response.setStatus(304);
                return;
            }
            response.setDateHeader("Last-Modified", last_modified);
        }
        if ((mime = this._mimeTypes.getMimeByExtension(request.getPathInfo())) != null) {
            response.setContentType(mime.toString());
        }
        if ((length = resource.length()) > 0L) {
            response.setHeader("Content-Length", TypeUtil.toString((long)length));
        }
        Object out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
        }
        if (out instanceof HttpConnection.Output) {
            ((HttpConnection.Output)((Object)out)).sendContent(resource.getInputStream());
        } else {
            resource.writeTo((OutputStream)out, 0L, length);
        }
    }
}

