/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.CapabilityBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortCapabilityBlock
implements Writable {
    private static final byte[] CAP_TEMPLATE_BYTES = new byte[]{9, 70, 0, 0, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0};
    public static final ByteBlock CAP_TEMPLATE = ByteBlock.wrap(CAP_TEMPLATE_BYTES);
    private final ByteBlock data;

    public static CapabilityBlock getCapFromShortBytes(int n, int n2) {
        byte[] byArray = CAP_TEMPLATE.toByteArray();
        byArray[2] = (byte)n;
        byArray[3] = (byte)n2;
        return new CapabilityBlock(ByteBlock.wrap(byArray));
    }

    public static List<ShortCapabilityBlock> readShortCaps(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        LinkedList<ShortCapabilityBlock> linkedList = new LinkedList<ShortCapabilityBlock>();
        for (int i = 0; i < byteBlock.getLength(); i += 2) {
            linkedList.add(new ShortCapabilityBlock(byteBlock.subBlock(i, 2)));
        }
        return DefensiveTools.getUnmodifiable(linkedList);
    }

    public static boolean couldBeShortBlock(CapabilityBlock capabilityBlock) {
        DefensiveTools.checkNull(capabilityBlock, "cap");
        ByteBlock byteBlock = capabilityBlock.getBlock();
        return byteBlock.subBlock(0, 2).equals(CAP_TEMPLATE.subBlock(0, 2)) && byteBlock.subBlock(4).equals(CAP_TEMPLATE.subBlock(4));
    }

    public static ShortCapabilityBlock getShortBlock(CapabilityBlock capabilityBlock) throws IllegalArgumentException {
        DefensiveTools.checkNull(capabilityBlock, "cap");
        if (!ShortCapabilityBlock.couldBeShortBlock(capabilityBlock)) {
            throw new IllegalArgumentException("Capability block '" + capabilityBlock + "' cannot be converted to a short capability block");
        }
        return new ShortCapabilityBlock(capabilityBlock.getBlock().subBlock(2, 2));
    }

    public ShortCapabilityBlock(ByteBlock byteBlock) throws IllegalArgumentException {
        DefensiveTools.checkNull(byteBlock, "data");
        if (byteBlock.getLength() != 2) {
            throw new IllegalArgumentException("short capability data block must contain only two bytes (it has " + byteBlock.getLength() + ": " + BinaryTools.describeData(byteBlock) + ")");
        }
        this.data = byteBlock;
    }

    public final ByteBlock getData() {
        return this.data;
    }

    public final CapabilityBlock toCapabilityBlock() {
        byte[] byArray = (byte[])CAP_TEMPLATE_BYTES.clone();
        System.arraycopy(this.data.toByteArray(), 0, byArray, 2, 2);
        return new CapabilityBlock(ByteBlock.wrap(byArray));
    }

    @Override
    public long getWritableLength() {
        return 2L;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.data.write(outputStream);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShortCapabilityBlock)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ShortCapabilityBlock shortCapabilityBlock = (ShortCapabilityBlock)object;
        return shortCapabilityBlock.data.equals(this.data);
    }

    public int hashCode() {
        return BinaryTools.getUShort(this.data, 0);
    }

    public String toString() {
        String string = MiscTools.findEqualField(CapabilityBlock.class, this.toCapabilityBlock(), "BLOCK_.*");
        return "ShortCapabilityBlock: " + BinaryTools.describeData(this.data) + " (" + (string == null ? "unknown" : string) + ")";
    }
}

