/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.ExtraInfoData;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtraInfoBlock
implements Writable {
    public static final int TYPE_ICONHASH = 1;
    public static final int TYPE_AVAILMSG = 2;
    public static final int TYPE_ITUNES_URL = 9;
    public static final int TYPE_AIMEXPINFO_A = 128;
    public static final int TYPE_AIMEXPINFO_B = 130;
    public static final int TYPE_CERTINFO_HASHA = 1026;
    public static final int TYPE_CERTINFO_HASHB = 1027;
    private final int type;
    private final ExtraInfoData extraData;
    private final int totalSize;

    public static List<ExtraInfoBlock> readExtraInfoBlocks(ByteBlock byteBlock) {
        ExtraInfoBlock extraInfoBlock;
        DefensiveTools.checkNull(byteBlock, "block");
        LinkedList<ExtraInfoBlock> linkedList = new LinkedList<ExtraInfoBlock>();
        ByteBlock byteBlock2 = byteBlock;
        while ((extraInfoBlock = ExtraInfoBlock.readExtraInfoBlock(byteBlock2)) != null) {
            linkedList.add(extraInfoBlock);
            byteBlock2 = byteBlock2.subBlock(extraInfoBlock.getTotalSize());
        }
        return DefensiveTools.getUnmodifiableCopy(linkedList);
    }

    @Nullable
    public static ExtraInfoBlock readExtraInfoBlock(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 2) {
            return null;
        }
        int n = BinaryTools.getUShort(byteBlock, 0);
        ByteBlock byteBlock2 = byteBlock.subBlock(2);
        ExtraInfoData extraInfoData = ExtraInfoData.readExtraInfoData(byteBlock2);
        int n2 = 2;
        if (extraInfoData != null) {
            n2 += extraInfoData.getTotalSize();
        }
        return new ExtraInfoBlock(n, extraInfoData, n2);
    }

    private ExtraInfoBlock(int n, ExtraInfoData extraInfoData, int n2) {
        DefensiveTools.checkRange(n, "code", 0);
        DefensiveTools.checkRange(n2, "totalSize", -1);
        this.type = n;
        this.extraData = extraInfoData;
        this.totalSize = n2;
    }

    public ExtraInfoBlock(int n, ExtraInfoData extraInfoData) {
        this(n, extraInfoData, -1);
    }

    public final int getType() {
        return this.type;
    }

    public final ExtraInfoData getExtraData() {
        return this.extraData;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public long getWritableLength() {
        return 2L + (this.extraData == null ? 0L : this.extraData.getWritableLength());
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.type);
        if (this.extraData != null) {
            this.extraData.write(outputStream);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ExtraInfoBlock extraInfoBlock = (ExtraInfoBlock)object;
        if (this.type != extraInfoBlock.type) {
            return false;
        }
        return !(this.extraData != null ? !this.extraData.equals(extraInfoBlock.extraData) : extraInfoBlock.extraData != null);
    }

    public int hashCode() {
        int n = this.type;
        n = 29 * n + (this.extraData != null ? this.extraData.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "ExtraInfoBlock: type=0x" + Long.toHexString(this.type) + " (" + MiscTools.findIntField(ExtraInfoBlock.class, this.type, "TYPE_.*") + ")" + ", extraData=<" + this.extraData + ">";
    }
}

