/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.rvproxy;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyPacket;

public class RvProxyErrorCmd
extends RvProxyCmd {
    public static final int ERRORCODE_TIMEOUT = 26;
    private final int errorCode;

    protected RvProxyErrorCmd(RvProxyPacket rvProxyPacket) {
        super(rvProxyPacket);
        ByteBlock byteBlock = rvProxyPacket.getCommandData();
        this.errorCode = BinaryTools.getUShort(byteBlock, 0);
    }

    public RvProxyErrorCmd(int n) {
        super(1);
        DefensiveTools.checkRange(n, "errorCode", 0);
        this.errorCode = n;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public void writeCommandData(OutputStream outputStream) throws IOException {
    }

    public String toString() {
        return "RvProxyErrorCmd: errorCode=" + this.errorCode;
    }
}

