/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl.operations;

import com.hazelcast.cluster.impl.operations.JoinOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.Arrays;

public class PostJoinOperation
extends AbstractOperation
implements UrgentSystemOperation,
JoinOperation {
    private Operation[] operations;

    public PostJoinOperation() {
    }

    public PostJoinOperation(Operation ... ops) {
        for (Operation op : ops) {
            Preconditions.checkNotNull(op, "op can't be null");
            Preconditions.checkNegative(op.getPartitionId(), "Post join operation can not have a partition-id!");
        }
        this.operations = ops;
    }

    @Override
    public void beforeRun() throws Exception {
        if (this.operations != null && this.operations.length > 0) {
            final NodeEngine nodeEngine = this.getNodeEngine();
            for (final Operation op : this.operations) {
                op.setNodeEngine(nodeEngine).setResponseHandler(new ResponseHandler(){

                    @Override
                    public void sendResponse(Object obj) {
                        if (obj instanceof Throwable) {
                            Throwable t = (Throwable)obj;
                            ILogger logger = nodeEngine.getLogger(op.getClass());
                            logger.warning("Error while running post-join operation: " + t.getClass().getSimpleName() + ": " + t.getMessage());
                            if (logger.isFinestEnabled()) {
                                logger.finest(t);
                            }
                        }
                    }

                    @Override
                    public boolean isLocal() {
                        return true;
                    }
                });
                OperationAccessor.setCallerAddress(op, this.getCallerAddress());
                OperationAccessor.setConnection(op, this.getConnection());
                this.operations[i] = op;
            }
        }
    }

    @Override
    public void run() throws Exception {
        if (this.operations != null && this.operations.length > 0) {
            OperationService operationService = this.getNodeEngine().getOperationService();
            for (Operation op : this.operations) {
                operationService.runOperationOnCallingThread(op);
            }
        }
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        int len = this.operations != null ? this.operations.length : 0;
        out.writeInt(len);
        if (len > 0) {
            for (Operation op : this.operations) {
                out.writeObject(op);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int len = in.readInt();
        this.operations = new Operation[len];
        for (int i = 0; i < len; ++i) {
            this.operations[i] = (Operation)in.readObject();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PostJoinOperation{");
        sb.append("operations=").append(Arrays.toString(this.operations));
        sb.append('}');
        return sb.toString();
    }
}

