/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmyspaceiml.contact;

import net.sf.jmyspaceiml.log.Log;

public class Contact {
    private int contactID;
    private String imName;
    private String headline;
    private int position;
    private String groupName;
    private int visibility;
    private String avatarUrl;
    private boolean showAvatar;
    private long lastLogin;
    private String nickName;
    private int nameSelect;
    private String offlineMsg;
    private int skyStatus;

    public Contact() {
    }

    public Contact(int contactID, String imName) {
        this.contactID = contactID;
        this.imName = imName;
    }

    public int getContactID() {
        return this.contactID;
    }

    public void setContactID(int contactID) {
        this.contactID = contactID;
    }

    public String getImName() {
        return this.imName;
    }

    public void setImName(String imName) {
        this.imName = imName;
    }

    public void setHeadline(String headline) {
        this.headline = headline;
    }

    public String getHeadline() {
        return this.headline;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setVisibility(int visibility) {
        this.visibility = visibility;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setShowAvatar(boolean showAvatar) {
        this.showAvatar = showAvatar;
    }

    public boolean isShowAvatar() {
        return this.showAvatar;
    }

    public void setLastLogin(long lastLogin) {
        this.lastLogin = lastLogin;
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNameSelect(int nameSelect) {
        this.nameSelect = nameSelect;
    }

    public int getNameSelect() {
        return this.nameSelect;
    }

    public void setOfflineMsg(String offlineMsg) {
        this.offlineMsg = offlineMsg;
    }

    public String getOfflineMsg() {
        return this.offlineMsg;
    }

    public void setSkyStatus(int skyStatus) {
        this.skyStatus = skyStatus;
    }

    public int getSkyStatus() {
        return this.skyStatus;
    }

    public void parsePacketData(String packetData) {
        String[] pairs;
        Log.debug("Parsing packet data: " + packetData);
        for (String pair : pairs = packetData.split("\u001c")) {
            Log.debug("Found pair: " + pair);
            String[] pcs = pair.split("=");
            if (pcs.length < 2) continue;
            if (pcs[0].equals("ContactID")) {
                this.contactID = Integer.parseInt(pcs[1]);
                continue;
            }
            if (pcs[0].equals("Headline")) {
                this.headline = pcs[1];
                continue;
            }
            if (pcs[0].equals("Position")) {
                this.position = Integer.parseInt(pcs[1]);
                continue;
            }
            if (pcs[0].equals("GroupName")) {
                this.groupName = pcs[1];
                continue;
            }
            if (pcs[0].equals("Visibility")) {
                this.visibility = Integer.parseInt(pcs[1]);
                continue;
            }
            if (pcs[0].equals("AvatarUrl")) {
                this.avatarUrl = pcs[1];
                continue;
            }
            if (pcs[0].equals("ShowAvatar")) {
                this.showAvatar = Boolean.parseBoolean(pcs[1]);
                continue;
            }
            if (pcs[0].equals("LastLogin")) {
                this.lastLogin = Long.parseLong(pcs[1]);
                continue;
            }
            if (pcs[0].equals("IMName")) {
                this.imName = pcs[1];
                continue;
            }
            if (pcs[0].equals("NickName")) {
                this.nickName = pcs[1];
                continue;
            }
            if (pcs[0].equals("NameSelect")) {
                this.nameSelect = Integer.parseInt(pcs[1]);
                continue;
            }
            if (pcs[0].equals("OfflineMsg")) {
                this.offlineMsg = pcs[1];
                continue;
            }
            if (!pcs[0].equals("SkyStatus")) continue;
            this.skyStatus = Integer.parseInt(pcs[1]);
        }
    }
}

