/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ymsg.network.YahooChatRoom;
import ymsg.network.YahooChatUser;

public class YahooChatLobby {
    protected int count;
    protected int userCount;
    protected int voiceCount;
    protected int webcamCount;
    protected YahooChatRoom parent;
    private String netName = null;
    private Hashtable users;

    YahooChatLobby(int cnt, int usr, int vce, int web) {
        this.count = cnt;
        this.userCount = usr;
        this.voiceCount = vce;
        this.webcamCount = web;
        this.users = new Hashtable();
    }

    void setParent(YahooChatRoom ycr) {
        this.parent = ycr;
        this.netName = this.parent.getName() + ":" + this.count;
    }

    void addUser(YahooChatUser ycu) {
        this.users.put(ycu.getId(), ycu);
    }

    void removeUser(YahooChatUser ycu) {
        this.users.remove(ycu.getId());
    }

    void clearUsers() {
        this.users.clear();
    }

    boolean exists(YahooChatUser ycu) {
        return this.users.containsKey(ycu.getId());
    }

    YahooChatUser getUser(String id) {
        return (YahooChatUser)this.users.get(id);
    }

    public int getLobbyNumber() {
        return this.count;
    }

    public int getUserCount() {
        return this.userCount;
    }

    public int getVoiceCount() {
        return this.voiceCount;
    }

    public int getWebcamCount() {
        return this.webcamCount;
    }

    public String getNetworkName() {
        return this.netName;
    }

    public YahooChatRoom getParent() {
        return this.parent;
    }

    public Vector getMembers() {
        Vector v = new Vector(this.userCount);
        Enumeration e = this.users.elements();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        return v;
    }

    public String toString() {
        return "count=" + this.count + " users=" + this.userCount + " voices=" + this.voiceCount + " webcams=" + this.webcamCount + " netname=" + this.netName;
    }
}

