/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.ssi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.BuddyItem;
import net.kano.joscar.ssiitem.SsiItemObjectWithId;
import net.kano.joustsim.oscar.oscar.service.ssi.Buddy;
import net.kano.joustsim.oscar.oscar.service.ssi.SimpleBuddy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SsiTools {
    private SsiTools() {
    }

    public static List<SsiItem> getBuddiesToDelete(List<Buddy> ingroup) {
        ArrayList<SsiItem> items = new ArrayList<SsiItem>();
        for (Buddy buddy : ingroup) {
            if (!(buddy instanceof SimpleBuddy)) {
                throw new IllegalArgumentException("can't delete buddy " + buddy + " : wrong type");
            }
            SimpleBuddy simpleBuddy = (SimpleBuddy)buddy;
            BuddyItem item = simpleBuddy.getItem();
            SsiItem ssiItem = item.toSsiItem();
            items.add(ssiItem);
        }
        return items;
    }

    public static List<Integer> getIdsForItems(List<SsiItem> items) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SsiItem ssiItem : items) {
            ids.add(ssiItem.getId());
        }
        return ids;
    }

    public static <E extends SsiItemObjectWithId> void removeItemsWithId(Collection<E> items, int id) {
        Iterator<E> it = items.iterator();
        while (it.hasNext()) {
            SsiItemObjectWithId otherItem = (SsiItemObjectWithId)it.next();
            if (otherItem.getId() != id) continue;
            it.remove();
        }
    }

    public static boolean isOnlyBuddies(List<SsiItem> items) {
        for (SsiItem item : items) {
            if (item.getItemType() == 0) continue;
            return false;
        }
        return true;
    }
}

