/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.cindy.util.ByteBufferUtils;
import net.sf.jml.MsnObject;
import net.sf.jml.message.MsnMimeMessage;
import net.sf.jml.message.p2p.DisplayPictureDuelManager;
import net.sf.jml.util.Charset;

public class MsnEmoticonMessage
extends MsnMimeMessage {
    public static final String EMOTICON_SEPARATOR = "\t";
    private Map emoticons;

    public MsnEmoticonMessage() {
        this.setContentType("text/x-mms-emoticon");
        this.emoticons = new HashMap(5);
    }

    public void putEmoticon(String string, MsnObject msnObject) {
        this.emoticons.put(string, msnObject);
        if (msnObject != null) {
            DisplayPictureDuelManager.getDuelManager().putPicture(msnObject.toString(), msnObject);
        }
    }

    protected void parseMessage(byte[] byArray) {
        ByteBuffer byteBuffer = Charset.encode("\r\n\r\n");
        int n = ByteBufferUtils.indexOf((ByteBuffer)ByteBuffer.wrap(byArray), (ByteBuffer)byteBuffer);
        String string = n == -1 ? Charset.decode(byArray) : Charset.decode(byArray, 0, n);
        this.headers.parseString(string);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byArray.length - (n += byteBuffer.remaining()));
        byteBuffer2.put(byArray, n, byArray.length - n);
        byteBuffer2.flip();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.emoticons.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append(EMOTICON_SEPARATOR);
            stringBuffer.append(this.emoticons.get(string));
            stringBuffer.append(EMOTICON_SEPARATOR);
        }
        return super.toString() + stringBuffer.toString();
    }
}

