/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import java.util.Collection;
import java.util.Iterator;
import net.sf.cindy.util.CopyOnWriteCollection;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnFileTransfer;
import net.sf.jml.MsnGroup;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnProtocol;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.event.MsnAdapter;
import net.sf.jml.event.MsnContactListListener;
import net.sf.jml.event.MsnFileTransferListener;
import net.sf.jml.event.MsnMessageListener;
import net.sf.jml.event.MsnMessengerListener;
import net.sf.jml.event.MsnSwitchboardListener;
import net.sf.jml.message.MsnControlMessage;
import net.sf.jml.message.MsnDatacastMessage;
import net.sf.jml.message.MsnInstantMessage;
import net.sf.jml.message.MsnSystemMessage;
import net.sf.jml.message.MsnUnknownMessage;
import net.sf.jml.protocol.MsnOutgoingMessage;

public abstract class AbstractMessenger
implements MsnMessenger {
    private Object attachment;
    private boolean logIncoming;
    private boolean logOutgoing;
    private MsnProtocol[] supportedProtocol = MsnProtocol.getAllSupportedProtocol();
    private MsnProtocol actualMsnProtocol;
    private final Collection messengerListeners = new CopyOnWriteCollection();
    private final Collection messageListeners = new CopyOnWriteCollection();
    private final Collection contactListListeners = new CopyOnWriteCollection();
    private final Collection switchboardListeners = new CopyOnWriteCollection();
    private final Collection fileTransferListeners = new CopyOnWriteCollection();

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object object) {
        this.attachment = object;
    }

    public boolean isLogIncoming() {
        return this.logIncoming;
    }

    public void setLogIncoming(boolean bl) {
        this.logIncoming = bl;
    }

    public boolean isLogOutgoing() {
        return this.logOutgoing;
    }

    public void setLogOutgoing(boolean bl) {
        this.logOutgoing = bl;
    }

    public MsnProtocol[] getSupportedProtocol() {
        return this.supportedProtocol;
    }

    public void setSupportedProtocol(MsnProtocol[] msnProtocolArray) {
        if (msnProtocolArray != null && msnProtocolArray.length > 0) {
            this.supportedProtocol = msnProtocolArray;
        }
    }

    public MsnProtocol getActualMsnProtocol() {
        return this.actualMsnProtocol;
    }

    public void setActualMsnProtocol(MsnProtocol msnProtocol) {
        this.actualMsnProtocol = msnProtocol;
    }

    public void send(MsnOutgoingMessage msnOutgoingMessage) {
        this.send(msnOutgoingMessage, false);
    }

    public void addListener(MsnAdapter msnAdapter) {
        this.addMessengerListener(msnAdapter);
        this.addMessageListener(msnAdapter);
        this.addContactListListener(msnAdapter);
        this.addSwitchboardListener(msnAdapter);
        this.addFileTransferListener(msnAdapter);
    }

    public void addMessengerListener(MsnMessengerListener msnMessengerListener) {
        if (msnMessengerListener != null) {
            this.messengerListeners.add(msnMessengerListener);
        }
    }

    public void removeMessengerListener(MsnMessengerListener msnMessengerListener) {
        if (msnMessengerListener != null) {
            this.messengerListeners.remove(msnMessengerListener);
        }
    }

    public void fireLoginCompleted() {
        Iterator iterator = this.messengerListeners.iterator();
        while (iterator.hasNext()) {
            MsnMessengerListener msnMessengerListener = (MsnMessengerListener)iterator.next();
            msnMessengerListener.loginCompleted(this);
        }
    }

    public void fireLogout() {
        Iterator iterator = this.messengerListeners.iterator();
        while (iterator.hasNext()) {
            MsnMessengerListener msnMessengerListener = (MsnMessengerListener)iterator.next();
            msnMessengerListener.logout(this);
        }
    }

    public void fireExceptionCaught(Throwable throwable) {
        Iterator iterator = this.messengerListeners.iterator();
        while (iterator.hasNext()) {
            MsnMessengerListener msnMessengerListener = (MsnMessengerListener)iterator.next();
            msnMessengerListener.exceptionCaught(this, throwable);
        }
    }

    public void addMessageListener(MsnMessageListener msnMessageListener) {
        if (msnMessageListener != null) {
            this.messageListeners.add(msnMessageListener);
        }
    }

    public void removeMessageListener(MsnMessageListener msnMessageListener) {
        if (msnMessageListener != null) {
            this.messageListeners.remove(msnMessageListener);
        }
    }

    public void fireInstantMessageReceived(MsnSwitchboard msnSwitchboard, MsnInstantMessage msnInstantMessage, MsnContact msnContact) {
        Iterator iterator = this.messageListeners.iterator();
        while (iterator.hasNext()) {
            MsnMessageListener msnMessageListener = (MsnMessageListener)iterator.next();
            msnMessageListener.instantMessageReceived(msnSwitchboard, msnInstantMessage, msnContact);
        }
    }

    public void fireControlMessageReceived(MsnSwitchboard msnSwitchboard, MsnControlMessage msnControlMessage, MsnContact msnContact) {
        Iterator iterator = this.messageListeners.iterator();
        while (iterator.hasNext()) {
            MsnMessageListener msnMessageListener = (MsnMessageListener)iterator.next();
            msnMessageListener.controlMessageReceived(msnSwitchboard, msnControlMessage, msnContact);
        }
    }

    public void fireSystemMessageReceived(MsnSystemMessage msnSystemMessage) {
        Iterator iterator = this.messageListeners.iterator();
        while (iterator.hasNext()) {
            MsnMessageListener msnMessageListener = (MsnMessageListener)iterator.next();
            msnMessageListener.systemMessageReceived(this, msnSystemMessage);
        }
    }

    public void fireDatacastMessageReceived(MsnSwitchboard msnSwitchboard, MsnDatacastMessage msnDatacastMessage, MsnContact msnContact) {
        Iterator iterator = this.messageListeners.iterator();
        while (iterator.hasNext()) {
            MsnMessageListener msnMessageListener = (MsnMessageListener)iterator.next();
            msnMessageListener.datacastMessageReceived(msnSwitchboard, msnDatacastMessage, msnContact);
        }
    }

    public void fireUnknownMessageReceived(MsnSwitchboard msnSwitchboard, MsnUnknownMessage msnUnknownMessage, MsnContact msnContact) {
        Iterator iterator = this.messageListeners.iterator();
        while (iterator.hasNext()) {
            MsnMessageListener msnMessageListener = (MsnMessageListener)iterator.next();
            msnMessageListener.unknownMessageReceived(msnSwitchboard, msnUnknownMessage, msnContact);
        }
    }

    public void addContactListListener(MsnContactListListener msnContactListListener) {
        if (msnContactListListener != null) {
            this.contactListListeners.add(msnContactListListener);
        }
    }

    public void removeContactListListener(MsnContactListListener msnContactListListener) {
        if (msnContactListListener != null) {
            this.contactListListeners.remove(msnContactListListener);
        }
    }

    public void fireContactListSyncCompleted() {
        Iterator iterator = this.contactListListeners.iterator();
        while (iterator.hasNext()) {
            MsnContactListListener msnContactListListener = (MsnContactListListener)iterator.next();
            msnContactListListener.contactListSyncCompleted(this);
        }
    }

    public void fireContactListInitCompleted() {
        Iterator iterator = this.contactListListeners.iterator();
        while (iterator.hasNext()) {
            MsnContactListListener msnContactListListener = (MsnContactListListener)iterator.next();
            msnContactListListener.contactListInitCompleted(this);
        }
    }

    public void fireContactStatusChanged(MsnContact msnContact) {
        Iterator iterator = this.contactListListeners.iterator();
        while (iterator.hasNext()) {
            MsnContactListListener msnContactListListener = (MsnContactListListener)iterator.next();
            msnContactListListener.contactStatusChanged(this, msnContact);
        }
    }

    public void fireOwnerStatusChanged() {
        Iterator iterator = this.contactListListeners.iterator();
        while (iterator.hasNext()) {
            MsnContactListListener msnContactListListener = (MsnContactListListener)iterator.next();
            msnContactListListener.ownerStatusChanged(this);
        }
    }

    public void fireContactAddedMe(MsnContact msnContact) {
        Iterator iterator = this.contactListListeners.iterator();
        while (iterator.hasNext()) {
            MsnContactListListener msnContactListListener = (MsnContactListListener)iterator.next();
            msnContactListListener.contactAddedMe(this, msnContact);
        }
    }

    public void fireContactRemovedMe(MsnContact msnContact) {
        Iterator iterator = this.contactListListeners.iterator();
        while (iterator.hasNext()) {
            MsnContactListListener msnContactListListener = (MsnContactListListener)iterator.next();
            msnContactListListener.contactRemovedMe(this, msnContact);
        }
    }

    public void fireContactAddCompleted(MsnContact msnContact) {
        Iterator iterator = this.contactListListeners.iterator();
        while (iterator.hasNext()) {
            MsnContactListListener msnContactListListener = (MsnContactListListener)iterator.next();
            msnContactListListener.contactAddCompleted(this, msnContact);
        }
    }

    public void fireContactRemoveCompleted(MsnContact msnContact) {
        Iterator iterator = this.contactListListeners.iterator();
        while (iterator.hasNext()) {
            MsnContactListListener msnContactListListener = (MsnContactListListener)iterator.next();
            msnContactListListener.contactRemoveCompleted(this, msnContact);
        }
    }

    public void fireGroupAddCompleted(MsnGroup msnGroup) {
        Iterator iterator = this.contactListListeners.iterator();
        while (iterator.hasNext()) {
            MsnContactListListener msnContactListListener = (MsnContactListListener)iterator.next();
            msnContactListListener.groupAddCompleted(this, msnGroup);
        }
    }

    public void fireGroupRemoveCompleted(MsnGroup msnGroup) {
        Iterator iterator = this.contactListListeners.iterator();
        while (iterator.hasNext()) {
            MsnContactListListener msnContactListListener = (MsnContactListListener)iterator.next();
            msnContactListListener.groupRemoveCompleted(this, msnGroup);
        }
    }

    public void addSwitchboardListener(MsnSwitchboardListener msnSwitchboardListener) {
        if (msnSwitchboardListener != null) {
            this.switchboardListeners.add(msnSwitchboardListener);
        }
    }

    public void removeSwitchboardListener(MsnSwitchboardListener msnSwitchboardListener) {
        if (msnSwitchboardListener != null) {
            this.switchboardListeners.remove(msnSwitchboardListener);
        }
    }

    public void fireSwitchboardStarted(MsnSwitchboard msnSwitchboard) {
        Iterator iterator = this.switchboardListeners.iterator();
        while (iterator.hasNext()) {
            MsnSwitchboardListener msnSwitchboardListener = (MsnSwitchboardListener)iterator.next();
            msnSwitchboardListener.switchboardStarted(msnSwitchboard);
        }
    }

    public void fireSwitchboardClosed(MsnSwitchboard msnSwitchboard) {
        Iterator iterator = this.switchboardListeners.iterator();
        while (iterator.hasNext()) {
            MsnSwitchboardListener msnSwitchboardListener = (MsnSwitchboardListener)iterator.next();
            msnSwitchboardListener.switchboardClosed(msnSwitchboard);
        }
    }

    public void fireContactJoinSwitchboard(MsnSwitchboard msnSwitchboard, MsnContact msnContact) {
        Iterator iterator = this.switchboardListeners.iterator();
        while (iterator.hasNext()) {
            MsnSwitchboardListener msnSwitchboardListener = (MsnSwitchboardListener)iterator.next();
            msnSwitchboardListener.contactJoinSwitchboard(msnSwitchboard, msnContact);
        }
    }

    public void fireContactLeaveSwitchboard(MsnSwitchboard msnSwitchboard, MsnContact msnContact) {
        Iterator iterator = this.switchboardListeners.iterator();
        while (iterator.hasNext()) {
            MsnSwitchboardListener msnSwitchboardListener = (MsnSwitchboardListener)iterator.next();
            msnSwitchboardListener.contactLeaveSwitchboard(msnSwitchboard, msnContact);
        }
    }

    public void addFileTransferListener(MsnFileTransferListener msnFileTransferListener) {
        if (msnFileTransferListener != null) {
            this.fileTransferListeners.add(msnFileTransferListener);
        }
    }

    public void removeFileTransferListener(MsnFileTransferListener msnFileTransferListener) {
        if (msnFileTransferListener != null) {
            this.fileTransferListeners.remove(msnFileTransferListener);
        }
    }

    public void fireFileTransferRequestReceived(MsnFileTransfer msnFileTransfer) {
        Iterator iterator = this.fileTransferListeners.iterator();
        while (iterator.hasNext()) {
            MsnFileTransferListener msnFileTransferListener = (MsnFileTransferListener)iterator.next();
            msnFileTransferListener.fileTransferRequestReceived(msnFileTransfer);
        }
    }

    public void fireFileTransferStarted(MsnFileTransfer msnFileTransfer) {
        Iterator iterator = this.fileTransferListeners.iterator();
        while (iterator.hasNext()) {
            MsnFileTransferListener msnFileTransferListener = (MsnFileTransferListener)iterator.next();
            msnFileTransferListener.fileTransferStarted(msnFileTransfer);
        }
    }

    public void fireFileTransferProcess(MsnFileTransfer msnFileTransfer) {
        Iterator iterator = this.fileTransferListeners.iterator();
        while (iterator.hasNext()) {
            MsnFileTransferListener msnFileTransferListener = (MsnFileTransferListener)iterator.next();
            msnFileTransferListener.fileTransferProcess(msnFileTransfer);
        }
    }

    public void fireFileTransferFinished(MsnFileTransfer msnFileTransfer) {
        Iterator iterator = this.fileTransferListeners.iterator();
        while (iterator.hasNext()) {
            MsnFileTransferListener msnFileTransferListener = (MsnFileTransferListener)iterator.next();
            msnFileTransferListener.fileTransferFinished(msnFileTransfer);
        }
    }
}

