/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.cindy.Message;
import net.sf.cindy.impl.AbstractSession;
import net.sf.cindy.impl.AbstractTimeoutSession;
import net.sf.cindy.impl.Constants;
import net.sf.cindy.impl.SimpleEventGenerator;
import net.sf.cindy.spi.EventGeneratorSpi;
import net.sf.cindy.util.queue.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ChannelSession
extends AbstractTimeoutSession {
    private static final Log log = LogFactory.getLog((Class)ChannelSession.class);
    private final Set writeLocks = Collections.synchronizedSet(new HashSet());
    private final Object closeLock = new Object();
    private final Object startLock = new Object();
    private SelectableChannel readChannel;
    private SelectableChannel writeChannel;
    private SelectionKey readKey;
    private SelectionKey writeKey;
    private volatile boolean started = false;
    private volatile boolean closing = false;

    public final boolean isStarted() {
        return this.started;
    }

    public final boolean isClosing() {
        return this.closing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl) {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.isAvailable()) {
                return;
            }
            this.closing = true;
            EventGeneratorSpi eventGeneratorSpi = (EventGeneratorSpi)this.getEventGenerator();
            eventGeneratorSpi.register(this, Constants.EV_UNREGISTER);
            if (bl && !eventGeneratorSpi.isEventGeneratorThread()) {
                try {
                    this.closeLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchSessionEstablished() {
        super.dispatchSessionEstablished();
        Object object = this.startLock;
        synchronized (object) {
            this.startLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSession(SelectableChannel selectableChannel, SelectableChannel selectableChannel2, boolean bl) {
        Object object = this.startLock;
        synchronized (object) {
            if (this.isStarted()) {
                return;
            }
            try {
                if (selectableChannel != null) {
                    selectableChannel.configureBlocking(false);
                }
                if (selectableChannel2 != null) {
                    selectableChannel2.configureBlocking(false);
                }
            }
            catch (IOException iOException) {
                this.dispatchException(iOException);
                if (selectableChannel != null) {
                    try {
                        selectableChannel.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                if (selectableChannel2 != null) {
                    try {
                        selectableChannel2.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                }
                this.dispatchSessionClosed();
                return;
            }
            this.readChannel = selectableChannel;
            this.writeChannel = selectableChannel2;
            this.started = true;
            EventGeneratorSpi eventGeneratorSpi = (EventGeneratorSpi)this.getEventGenerator();
            if (!eventGeneratorSpi.isStarted()) {
                eventGeneratorSpi.start();
            }
            eventGeneratorSpi.register(this, Constants.EV_REGISTER);
            if (bl && !eventGeneratorSpi.isEventGeneratorThread()) {
                try {
                    this.startLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void onEvent(Object object, Object object2) {
        if (object == Constants.EV_READABLE) {
            this.onReadable();
        } else if (object == Constants.EV_ENABLE_READ) {
            this.onEnableRead();
        } else if (object == Constants.EV_WRITABLE) {
            this.onWritable();
        } else if (object == Constants.EV_ENABLE_WRITE) {
            this.onEnableWrite();
        } else if (object == Constants.EV_UNREGISTER) {
            this.onUnregister();
        } else if (object == Constants.EV_REGISTER) {
            this.onRegister((Selector)object2);
        }
        super.onEvent(object, object2);
    }

    private void onEnableRead() {
        if (this.readKey != null && this.readKey.isValid()) {
            this.readKey.interestOps(this.readKey.interestOps() | 1);
        }
    }

    private void onEnableWrite() {
        if (this.writeKey != null && this.writeKey.isValid()) {
            this.writeKey.interestOps(this.writeKey.interestOps() | 4);
        }
    }

    protected void onRegister(Selector selector) {
        this.readKey = this.readChannel.keyFor(selector);
        this.writeKey = this.writeChannel.keyFor(selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUnregister() {
        try {
            if (this.readKey != null) {
                this.readKey.cancel();
                this.readKey = null;
            }
            if (this.readChannel != null) {
                this.readChannel.close();
                this.readChannel = null;
            }
            if (this.writeKey != null) {
                this.writeKey.cancel();
                this.writeKey = null;
            }
            if (this.writeChannel != null) {
                this.writeChannel.close();
                this.writeChannel = null;
            }
        }
        catch (IOException iOException) {
            this.dispatchException(iOException);
        }
        this.writeQueue.clear();
        Object object = this.startLock;
        synchronized (object) {
            Object object2 = this.closeLock;
            synchronized (object2) {
                Set set = this.writeLocks;
                synchronized (set) {
                    Iterator iterator = this.writeLocks.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        iterator.remove();
                        Object e2 = e;
                        synchronized (e2) {
                            e.notify();
                        }
                    }
                }
                this.closing = false;
                this.started = false;
                this.startLock.notify();
                this.closeLock.notify();
            }
        }
        this.dispatchSessionClosed();
    }

    private void onReadable() {
        try {
            this.readKey.interestOps(this.readKey.interestOps() & 0xFFFFFFFE);
            this.readFromChannel(this.readChannel);
        }
        catch (CancelledKeyException cancelledKeyException) {
            this.close();
        }
        catch (ClosedChannelException closedChannelException) {
            this.close();
        }
        catch (IOException iOException) {
            this.dispatchException(iOException);
            this.close();
        }
        catch (Exception exception) {
            this.dispatchException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWritable() {
        try {
            this.writeKey.interestOps(this.writeKey.interestOps() & 0xFFFFFFFB);
            boolean bl = false;
            while (true) {
                Object[] objectArray;
                if ((objectArray = (Object[])this.writeQueue.peek()) == null) {
                    bl = true;
                    break;
                }
                Message message = this.writeToChannel(this.writeChannel, objectArray[0]);
                if (message == null) break;
                this.writeQueue.pop();
                this.dispatchMessageSent(message);
                AbstractSession.WriteLock writeLock = (AbstractSession.WriteLock)objectArray[1];
                if (writeLock == null) continue;
                writeLock.setSuccess(true);
                AbstractSession.WriteLock writeLock2 = writeLock;
                synchronized (writeLock2) {
                    writeLock.notify();
                }
            }
            if (bl) {
                this.dispatchSessionIdle();
            } else {
                ((EventGeneratorSpi)this.getEventGenerator()).register(this, Constants.EV_ENABLE_WRITE);
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            this.close();
        }
        catch (ClosedChannelException closedChannelException) {
            this.close();
        }
        catch (IOException iOException) {
            this.dispatchException(iOException);
            this.close();
        }
        catch (Exception exception) {
            this.dispatchException(exception);
        }
    }

    protected void readFromChannel(SelectableChannel selectableChannel) throws IOException {
    }

    protected Message writeToChannel(SelectableChannel selectableChannel, Object object) throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToWriteQueue(Object object) {
        Queue queue = this.writeQueue;
        synchronized (queue) {
            if (this.writeQueue.isEmpty()) {
                this.writeQueue.push(object);
                ((EventGeneratorSpi)this.getEventGenerator()).register(this, Constants.EV_ENABLE_WRITE);
            } else {
                this.writeQueue.push(object);
            }
        }
    }

    protected Object transMessage(Message message) throws IllegalArgumentException {
        return message;
    }

    public void write(Message message) throws IllegalArgumentException, IllegalStateException {
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        if (!this.isAvailable()) {
            throw new IllegalStateException("session is not available");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("session " + this.getId() + " write message " + message));
        }
        this.writeToWriteQueue(new Object[]{this.transMessage(message), null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean blockWrite(Message message) throws IllegalArgumentException, IllegalStateException {
        AbstractSession.WriteLock writeLock;
        Object object;
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        if (!this.isAvailable()) {
            throw new IllegalStateException("session is not available");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("session " + this.getId() + " block write message " + message));
        }
        if ((object = this.transMessage(message)) == null) {
            return false;
        }
        AbstractSession.WriteLock writeLock2 = writeLock = new AbstractSession.WriteLock();
        synchronized (writeLock2) {
            this.writeToWriteQueue(new Object[]{object, writeLock});
            if (!((SimpleEventGenerator)this.getEventGenerator()).isEventGeneratorThread()) {
                this.writeLocks.add(writeLock);
                try {
                    writeLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.writeLocks.remove(writeLock);
                return writeLock.isSuccess();
            }
            block14: while (true) {
                try {
                    while (true) {
                        Object[] objectArray;
                        Message message2;
                        if ((message2 = this.writeToChannel(this.writeChannel, (objectArray = (Object[])this.writeQueue.peek())[0])) != null) {
                            this.writeQueue.pop();
                            this.dispatchMessageSent(message2);
                            if (objectArray[1] != null) {
                                AbstractSession.WriteLock writeLock3 = (AbstractSession.WriteLock)objectArray[1];
                                writeLock3.setSuccess(true);
                                AbstractSession.WriteLock writeLock4 = writeLock3;
                                synchronized (writeLock4) {
                                    writeLock3.notify();
                                }
                            }
                            if (object != objectArray[0]) continue;
                            return true;
                        }
                        try {
                            Thread.sleep(10L);
                            continue block14;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (ClosedChannelException closedChannelException) {
                    this.close();
                    break;
                }
                catch (IOException iOException) {
                    this.dispatchException(iOException);
                    this.close();
                    break;
                }
                catch (Exception exception) {
                    this.dispatchException(exception);
                    break;
                }
            }
        }
        return false;
    }
}

