/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.management;

import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.common.ExecutorThreadModel;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.management.IoSessionStat;

public class StatCollector {
    public static final String KEY = StatCollector.class.getName() + ".stat";
    private static volatile int nextId = 0;
    private final int id = nextId++;
    private final IoService service;
    private Worker worker;
    private int pollingInterval = 5000;
    private Queue<IoSession> polledSessions;
    private AtomicLong totalProcessedSessions = new AtomicLong();
    private AtomicLong totalMsgWritten = new AtomicLong();
    private AtomicLong totalMsgRead = new AtomicLong();
    private AtomicLong totalBytesWritten = new AtomicLong();
    private AtomicLong totalBytesRead = new AtomicLong();
    private AtomicLong totalScheduledWrites = new AtomicLong();
    private AtomicLong totalQueuedEvents = new AtomicLong();
    private final IoServiceListener serviceListener = new IoServiceListener(){

        public void serviceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        }

        public void serviceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        }

        public void sessionCreated(IoSession session) {
            StatCollector.this.addSession(session);
        }

        public void sessionDestroyed(IoSession session) {
            StatCollector.this.removeSession(session);
        }
    };

    public StatCollector(IoService service) {
        this(service, 5000);
    }

    public StatCollector(IoService service, int pollingInterval) {
        this.service = service;
        this.pollingInterval = pollingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            if (this.worker != null && this.worker.isAlive()) {
                throw new RuntimeException("Stat collecting already started");
            }
            this.polledSessions = new ConcurrentLinkedQueue<IoSession>();
            for (SocketAddress element : this.service.getManagedServiceAddresses()) {
                Iterator<IoSession> iter2 = this.service.getManagedSessions(element).iterator();
                while (iter2.hasNext()) {
                    this.addSession(iter2.next());
                }
            }
            this.service.addListener(this.serviceListener);
            this.worker = new Worker();
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            this.service.removeListener(this.serviceListener);
            this.worker.stop = true;
            this.worker.interrupt();
            while (this.worker.isAlive()) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException e) {}
            }
            for (IoSession session : this.polledSessions) {
                session.removeAttribute(KEY);
            }
            this.polledSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        StatCollector statCollector = this;
        synchronized (statCollector) {
            return this.worker != null && !this.worker.stop;
        }
    }

    private void addSession(IoSession session) {
        IoSessionStat sessionStats = new IoSessionStat();
        sessionStats.lastPollingTime = System.currentTimeMillis();
        session.setAttribute(KEY, sessionStats);
        this.totalProcessedSessions.incrementAndGet();
        this.polledSessions.add(session);
    }

    private void removeSession(IoSession session) {
        this.polledSessions.remove(session);
        IoSessionStat sessStat = (IoSessionStat)session.getAttribute(KEY);
        session.removeAttribute(KEY);
        this.totalMsgWritten.addAndGet(session.getWrittenMessages() - sessStat.lastMessageWrite);
        this.totalMsgRead.addAndGet(session.getReadMessages() - sessStat.lastMessageRead);
        this.totalBytesWritten.addAndGet(session.getWrittenBytes() - sessStat.lastByteWrite);
        this.totalBytesRead.addAndGet(session.getReadBytes() - sessStat.lastByteRead);
    }

    public long getTotalProcessedSessions() {
        return this.totalProcessedSessions.longValue();
    }

    public long getBytesRead() {
        return this.totalBytesRead.get();
    }

    public long getBytesWritten() {
        return this.totalBytesWritten.get();
    }

    public long getMsgRead() {
        return this.totalMsgRead.get();
    }

    public long getMsgWritten() {
        return this.totalMsgWritten.get();
    }

    public long getScheduledWrites() {
        return this.totalScheduledWrites.get();
    }

    public long getQueuedEvents() {
        return this.totalQueuedEvents.get();
    }

    public long getSessionCount() {
        return this.polledSessions.size();
    }

    private class Worker
    extends Thread {
        boolean stop;

        private Worker() {
            super("StatCollectorWorker-" + StatCollector.this.id);
            this.stop = false;
        }

        public void run() {
            while (!this.stop) {
                try {
                    Thread.sleep(StatCollector.this.pollingInterval);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long tmpMsgWritten = 0L;
                long tmpMsgRead = 0L;
                long tmpBytesWritten = 0L;
                long tmpBytesRead = 0L;
                long tmpScheduledWrites = 0L;
                long tmpQueuevedEvents = 0L;
                for (IoSession session : StatCollector.this.polledSessions) {
                    IoSessionStat sessStat = (IoSessionStat)session.getAttribute(KEY);
                    long currentTimestamp = System.currentTimeMillis();
                    float pollDelta = (float)(currentTimestamp - sessStat.lastPollingTime) / 1000.0f;
                    sessStat.lastPollingTime = currentTimestamp;
                    long readBytes = session.getReadBytes();
                    long writtenBytes = session.getWrittenBytes();
                    long readMessages = session.getReadMessages();
                    long writtenMessages = session.getWrittenMessages();
                    sessStat.byteReadThroughput = (float)(readBytes - sessStat.lastByteRead) / pollDelta;
                    sessStat.byteWrittenThroughput = (float)(writtenBytes - sessStat.lastByteWrite) / pollDelta;
                    sessStat.messageReadThroughput = (float)(readMessages - sessStat.lastMessageRead) / pollDelta;
                    sessStat.messageWrittenThroughput = (float)(writtenMessages - sessStat.lastMessageWrite) / pollDelta;
                    tmpMsgWritten += writtenMessages - sessStat.lastMessageWrite;
                    tmpMsgRead += readMessages - sessStat.lastMessageRead;
                    tmpBytesWritten += writtenBytes - sessStat.lastByteWrite;
                    tmpBytesRead += readBytes - sessStat.lastByteRead;
                    tmpScheduledWrites += (long)session.getScheduledWriteRequests();
                    ExecutorFilter executorFilter = (ExecutorFilter)session.getFilterChain().get(ExecutorThreadModel.class.getName());
                    if (executorFilter != null) {
                        tmpQueuevedEvents += (long)executorFilter.getEventQueueSize(session);
                    }
                    sessStat.lastByteRead = readBytes;
                    sessStat.lastByteWrite = writtenBytes;
                    sessStat.lastMessageRead = readMessages;
                    sessStat.lastMessageWrite = writtenMessages;
                }
                StatCollector.this.totalMsgWritten.addAndGet(tmpMsgWritten);
                StatCollector.this.totalMsgRead.addAndGet(tmpMsgRead);
                StatCollector.this.totalBytesWritten.addAndGet(tmpBytesWritten);
                StatCollector.this.totalBytesRead.addAndGet(tmpBytesRead);
                StatCollector.this.totalScheduledWrites.set(tmpScheduledWrites);
                StatCollector.this.totalQueuedEvents.set(tmpQueuevedEvents);
            }
        }
    }
}

