/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.store.Directory;

public class ConcurrentMergeScheduler
extends MergeScheduler {
    private int mergeThreadPriority = -1;
    protected List mergeThreads = new ArrayList();
    private int maxThreadCount = 1;
    protected Directory dir;
    private boolean closed;
    protected IndexWriter writer;
    protected int mergeThreadCount;
    static boolean anyExceptions = false;
    private boolean suppressExceptions;
    private static List allInstances;
    static /* synthetic */ Class class$org$apache$lucene$index$ConcurrentMergeScheduler;

    public ConcurrentMergeScheduler() {
        if (allInstances != null) {
            this.addMyself();
        }
    }

    public void setMaxThreadCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("count should be at least 1");
        }
        this.maxThreadCount = count;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public synchronized int getMergeThreadPriority() {
        this.initMergeThreadPriority();
        return this.mergeThreadPriority;
    }

    public synchronized void setMergeThreadPriority(int pri) {
        if (pri > 10 || pri < 1) {
            throw new IllegalArgumentException("priority must be in range 1 .. 10 inclusive");
        }
        this.mergeThreadPriority = pri;
        int numThreads = this.mergeThreadCount();
        for (int i = 0; i < numThreads; ++i) {
            MergeThread merge = (MergeThread)this.mergeThreads.get(i);
            merge.setThreadPriority(pri);
        }
    }

    private boolean verbose() {
        return this.writer != null && this.writer.verbose();
    }

    private void message(String message) {
        if (this.verbose()) {
            this.writer.message("CMS: " + message);
        }
    }

    private synchronized void initMergeThreadPriority() {
        if (this.mergeThreadPriority == -1) {
            this.mergeThreadPriority = 1 + Thread.currentThread().getPriority();
            if (this.mergeThreadPriority > 10) {
                this.mergeThreadPriority = 10;
            }
        }
    }

    public void close() {
        this.closed = true;
    }

    public synchronized void sync() {
        while (this.mergeThreadCount() > 0) {
            if (this.verbose()) {
                this.message("now wait for threads; currently " + this.mergeThreads.size() + " still running");
            }
            int count = this.mergeThreads.size();
            if (this.verbose()) {
                for (int i = 0; i < count; ++i) {
                    this.message("    " + i + ": " + (MergeThread)this.mergeThreads.get(i));
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
        }
    }

    private synchronized int mergeThreadCount() {
        return this.mergeThreadCount(false);
    }

    private synchronized int mergeThreadCount(boolean excludeDone) {
        int count = 0;
        int numThreads = this.mergeThreads.size();
        for (int i = 0; i < numThreads; ++i) {
            MergeThread t = (MergeThread)this.mergeThreads.get(i);
            if (!t.isAlive()) continue;
            MergePolicy.OneMerge runningMerge = t.getRunningMerge();
            if (excludeDone && (runningMerge == null || runningMerge.mergeDone)) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(IndexWriter writer) throws CorruptIndexException, IOException {
        this.writer = writer;
        this.initMergeThreadPriority();
        this.dir = writer.getDirectory();
        if (this.verbose()) {
            this.message("now merge");
            this.message("  index: " + writer.segString());
        }
        while (true) {
            Object var9_6;
            MergePolicy.OneMerge merge;
            if ((merge = writer.getNextMerge()) == null) {
                if (this.verbose()) {
                    this.message("  no more merges pending; now return");
                }
                return;
            }
            writer.mergeInit(merge);
            boolean success = false;
            try {
                ConcurrentMergeScheduler concurrentMergeScheduler = this;
                synchronized (concurrentMergeScheduler) {
                    while (this.mergeThreadCount(true) >= this.maxThreadCount) {
                        if (this.verbose()) {
                            this.message("    too many merge threads running; stalling...");
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException(ie);
                        }
                    }
                    if (this.verbose()) {
                        this.message("  consider merge " + merge.segString(this.dir));
                    }
                    MergeThread merger = this.getMergeThread(writer, merge);
                    this.mergeThreads.add(merger);
                    if (this.verbose()) {
                        this.message("    launch new thread [" + merger.getName() + "]");
                    }
                    merger.start();
                    success = true;
                }
                var9_6 = null;
                if (success) continue;
            }
            catch (Throwable throwable) {
                var9_6 = null;
                if (!success) {
                    writer.mergeFinish(merge);
                }
                throw throwable;
            }
            writer.mergeFinish(merge);
        }
    }

    protected void doMerge(MergePolicy.OneMerge merge) throws IOException {
        this.writer.merge(merge);
    }

    protected synchronized MergeThread getMergeThread(IndexWriter writer, MergePolicy.OneMerge merge) throws IOException {
        MergeThread thread = new MergeThread(writer, merge);
        thread.setThreadPriority(this.mergeThreadPriority);
        thread.setDaemon(true);
        thread.setName("Lucene Merge Thread #" + this.mergeThreadCount++);
        return thread;
    }

    protected void handleMergeException(Throwable exc) {
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
        throw new MergePolicy.MergeException(exc, this.dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean anyUnhandledExceptions() {
        if (allInstances == null) {
            throw new RuntimeException("setTestMode() was not called; often this is because your test case's setUp method fails to call super.setUp in LuceneTestCase");
        }
        List list = allInstances;
        synchronized (list) {
            int count = allInstances.size();
            for (int i = 0; i < count; ++i) {
                ((ConcurrentMergeScheduler)allInstances.get(i)).sync();
            }
            boolean v = anyExceptions;
            anyExceptions = false;
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearUnhandledExceptions() {
        List list = allInstances;
        synchronized (list) {
            anyExceptions = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMyself() {
        List list = allInstances;
        synchronized (list) {
            int size = allInstances.size();
            int upto = 0;
            for (int i = 0; i < size; ++i) {
                ConcurrentMergeScheduler other = (ConcurrentMergeScheduler)allInstances.get(i);
                if (other.closed && 0 == other.mergeThreadCount()) continue;
                allInstances.set(upto++, other);
            }
            allInstances.subList(upto, allInstances.size()).clear();
            allInstances.add(this);
        }
    }

    void setSuppressExceptions() {
        this.suppressExceptions = true;
    }

    void clearSuppressExceptions() {
        this.suppressExceptions = false;
    }

    public static void setTestMode() {
        allInstances = new ArrayList();
    }

    protected class MergeThread
    extends Thread {
        IndexWriter writer;
        MergePolicy.OneMerge startMerge;
        MergePolicy.OneMerge runningMerge;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MergeThread(IndexWriter writer, MergePolicy.OneMerge startMerge) throws IOException {
            this.writer = writer;
            this.startMerge = startMerge;
        }

        public synchronized void setRunningMerge(MergePolicy.OneMerge merge) {
            this.runningMerge = merge;
        }

        public synchronized MergePolicy.OneMerge getRunningMerge() {
            return this.runningMerge;
        }

        public void setThreadPriority(int pri) {
            try {
                this.setPriority(pri);
            }
            catch (NullPointerException npe) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ConcurrentMergeScheduler concurrentMergeScheduler;
            MergePolicy.OneMerge merge = this.startMerge;
            try {
                try {
                    if (ConcurrentMergeScheduler.this.verbose()) {
                        ConcurrentMergeScheduler.this.message("  merge thread: start");
                    }
                    while (true) {
                        this.setRunningMerge(merge);
                        ConcurrentMergeScheduler.this.doMerge(merge);
                        merge = this.writer.getNextMerge();
                        if (merge == null) break;
                        this.writer.mergeInit(merge);
                        if (!ConcurrentMergeScheduler.this.verbose()) continue;
                        ConcurrentMergeScheduler.this.message("  merge thread: do another merge " + merge.segString(ConcurrentMergeScheduler.this.dir));
                    }
                    if (ConcurrentMergeScheduler.this.verbose()) {
                        ConcurrentMergeScheduler.this.message("  merge thread: done");
                    }
                }
                catch (Throwable exc) {
                    if (!(exc instanceof MergePolicy.MergeAbortedException) && !ConcurrentMergeScheduler.this.suppressExceptions) {
                        anyExceptions = true;
                        ConcurrentMergeScheduler.this.handleMergeException(exc);
                    }
                    Object var4_3 = null;
                    ConcurrentMergeScheduler concurrentMergeScheduler3 = ConcurrentMergeScheduler.this;
                    synchronized (concurrentMergeScheduler3) {
                        ConcurrentMergeScheduler.this.notifyAll();
                        boolean removed = ConcurrentMergeScheduler.this.mergeThreads.remove(this);
                        if ($assertionsDisabled) return;
                        if (removed) return;
                        throw new AssertionError();
                    }
                }
                Object var4_2 = null;
                concurrentMergeScheduler = ConcurrentMergeScheduler.this;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ConcurrentMergeScheduler concurrentMergeScheduler2 = ConcurrentMergeScheduler.this;
                synchronized (concurrentMergeScheduler2) {
                    ConcurrentMergeScheduler.this.notifyAll();
                    boolean removed = ConcurrentMergeScheduler.this.mergeThreads.remove(this);
                    if ($assertionsDisabled) throw throwable;
                    if (removed) throw throwable;
                    throw new AssertionError();
                }
            }
            synchronized (concurrentMergeScheduler) {
                ConcurrentMergeScheduler.this.notifyAll();
                boolean removed = ConcurrentMergeScheduler.this.mergeThreads.remove(this);
                if ($assertionsDisabled) return;
                if (removed) return;
                throw new AssertionError();
            }
        }

        public String toString() {
            MergePolicy.OneMerge merge = this.getRunningMerge();
            if (merge == null) {
                merge = this.startMerge;
            }
            return "merge thread: " + merge.segString(ConcurrentMergeScheduler.this.dir);
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$ConcurrentMergeScheduler == null ? (class$org$apache$lucene$index$ConcurrentMergeScheduler = ConcurrentMergeScheduler.class$("org.apache.lucene.index.ConcurrentMergeScheduler")) : class$org$apache$lucene$index$ConcurrentMergeScheduler).desiredAssertionStatus();
        }
    }
}

