/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.auth.AuthCommand;

public class KeyResponse
extends AuthCommand {
    private final ByteBlock key;

    protected KeyResponse(SnacPacket snacPacket) {
        super(7);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        if (byteBlock.getLength() < 2) {
            this.key = null;
            return;
        }
        int n = BinaryTools.getUShort(byteBlock, 0);
        this.key = byteBlock.subBlock(2, n);
    }

    public KeyResponse(ByteBlock byteBlock) {
        super(7);
        this.key = byteBlock;
    }

    public final ByteBlock getKey() {
        return this.key;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        int n = this.key == null ? 0 : (int)this.key.getWritableLength();
        BinaryTools.writeUShort(outputStream, n);
        if (this.key != null) {
            this.key.write(outputStream);
        }
    }

    public String toString() {
        return "KeyResponse: key=" + BinaryTools.getAsciiString(this.key);
    }
}

