/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.SsiItemObj;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public abstract class AbstractItemObj
implements SsiItemObj {
    private final MutableTlvChain extraTlvs = TlvTools.createMutableChain();

    public static SsiItem[] generateSsiItems(SsiItemObj[] ssiItemObjArray) {
        DefensiveTools.checkNull(ssiItemObjArray, "itemObjs");
        SsiItem[] ssiItemArray = new SsiItem[ssiItemObjArray.length];
        for (int i = 0; i < ssiItemObjArray.length; ++i) {
            ssiItemArray[i] = ssiItemObjArray[i].toSsiItem();
        }
        return ssiItemArray;
    }

    protected AbstractItemObj() {
        this(null);
    }

    protected AbstractItemObj(TlvChain tlvChain) {
        if (tlvChain != null) {
            this.addExtraTlvs(tlvChain);
        }
    }

    protected final TlvChain copyExtraTlvs() {
        return TlvTools.getMutableCopy(this.extraTlvs);
    }

    public final MutableTlvChain getExtraTlvs() {
        return this.extraTlvs;
    }

    protected final void addExtraTlvs(TlvChain tlvChain) {
        this.extraTlvs.addAll(tlvChain);
    }

    protected final SsiItem generateItem(String string, int n, int n2, int n3, TlvChain tlvChain) {
        MutableTlvChain mutableTlvChain = TlvTools.getMutableCopy(this.extraTlvs);
        if (tlvChain != null) {
            mutableTlvChain.replaceAll(tlvChain);
        }
        return new SsiItem(string, n, n2, n3, ByteBlock.createByteBlock(mutableTlvChain));
    }
}

