/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.log;

import org.jitsi.videobridge.log.Event;

public class EventFactory {
    private static final String[] CONFERENCE_CREATED_COLUMNS = new String[]{"conference_id", "focus"};
    private static final String[] CONFERENCE_EXPIRED_COLUMNS = new String[]{"conference_id"};
    private static final String[] CONTENT_CREATED_COLUMNS = new String[]{"name", "conference_id"};
    private static final String[] CONTENT_EXPIRED_COLUMNS = CONTENT_CREATED_COLUMNS;
    private static final String[] CHANNEL_CREATED_COLUMNS = new String[]{"channel_id", "content_name", "conference_id"};
    private static final String[] CHANNEL_EXPIRED_COLUMNS = CHANNEL_CREATED_COLUMNS;
    private static final String[] TRANSPORT_CREATED_COLUMNS = new String[]{"hash_code", "conference_id", "num_components", "ufrag", "is_controlling"};
    private static final String[] TRANSPORT_CHANNEL_ADDED_COLUMNS = new String[]{"hash_code", "conference_id", "channel_id"};
    private static final String[] TRANSPORT_CHANNEL_REMOVED_COLUMNS = TRANSPORT_CHANNEL_ADDED_COLUMNS;
    private static final String[] TRANSPORT_CONNECTED_COLUMNS = new String[]{"hash_code", "conference_id", "selected_pairs"};
    private static final String[] TRANSPORT_STATE_CHANGED_COLUMNS = new String[]{"hash_code", "conference_id", "old_state", "new_state"};
    private static final String[] ENDPOINT_CREATED_COLUMNS = new String[]{"conference_id", "endpoint_id"};
    private static final String[] FOCUS_CREATED_COLUMNS = new String[]{"room_jid"};
    private static final String[] CONFERENCE_ROOM_COLUMNS = new String[]{"conference_id", "room_jid"};
    private static final String[] ENDPOINT_DISPLAY_NAME_COLUMNS = new String[]{"conference_id", "endpoint_id", "display_name"};

    public static Event conferenceCreated(String id, String focus) {
        return new Event("conference_created", CONFERENCE_CREATED_COLUMNS, new Object[]{id, focus != null ? focus : "null"});
    }

    public static Event contentCreated(String name, String conferenceId) {
        return new Event("content_created", CONTENT_CREATED_COLUMNS, new Object[]{name, conferenceId});
    }

    public static Event channelCreated(String id, String contentName, String conferenceId) {
        return new Event("channel_created", CHANNEL_CREATED_COLUMNS, new Object[]{id, contentName, conferenceId});
    }

    public static Event conferenceExpired(String id) {
        return new Event("conference_expired", CONFERENCE_EXPIRED_COLUMNS, new Object[]{id});
    }

    public static Event contentExpired(String name, String conferenceId) {
        return new Event("content_expired", CONTENT_EXPIRED_COLUMNS, new Object[]{name, conferenceId});
    }

    public static Event channelExpired(String id, String contentName, String conferenceId) {
        return new Event("channel_expired", CHANNEL_EXPIRED_COLUMNS, new Object[]{id, contentName, conferenceId});
    }

    public static Event transportCreated(int hashCode, String conferenceId, int numComponents, String ufrag, boolean isControlling) {
        return new Event("transport_created", TRANSPORT_CREATED_COLUMNS, new Object[]{String.valueOf(hashCode), conferenceId, numComponents, ufrag, Boolean.valueOf(isControlling).toString()});
    }

    public static Event transportChannelAdded(int hashCode, String conferenceId, String channelId) {
        return new Event("transport_channel_added", TRANSPORT_CHANNEL_ADDED_COLUMNS, new Object[]{String.valueOf(hashCode), conferenceId, channelId});
    }

    public static Event transportChannelRemoved(int hashCode, String conferenceId, String channelId) {
        return new Event("transport_channel_removed", TRANSPORT_CHANNEL_REMOVED_COLUMNS, new Object[]{String.valueOf(hashCode), conferenceId, channelId});
    }

    public static Event transportConnected(int hashCode, String conferenceId, String selectedPairs) {
        return new Event("transport_connected", TRANSPORT_CONNECTED_COLUMNS, new Object[]{String.valueOf(hashCode), conferenceId, selectedPairs});
    }

    public static Event transportStateChanged(int hashCode, String conferenceId, String oldState, String newState) {
        return new Event("transport_state_changed", TRANSPORT_STATE_CHANGED_COLUMNS, new Object[]{String.valueOf(hashCode), conferenceId, oldState, newState});
    }

    public static Event endpointCreated(String conferenceId, String endpointId) {
        return new Event("endpoint_created", ENDPOINT_CREATED_COLUMNS, new Object[]{conferenceId, endpointId});
    }

    public static Event focusCreated(String roomJid) {
        return new Event("focus_created", FOCUS_CREATED_COLUMNS, new Object[]{roomJid});
    }

    public static Event conferenceRoom(String conferenceId, String roomJid) {
        return new Event("conference_room", CONFERENCE_ROOM_COLUMNS, new Object[]{conferenceId, roomJid});
    }

    public static Event endpointDisplayNameChanged(String conferenceId, String endpointId, String displayName) {
        return new Event("endpoint_display_name", ENDPOINT_DISPLAY_NAME_COLUMNS, new Object[]{conferenceId, endpointId, displayName});
    }
}

