/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.Format;
import javax.media.rtp.OutputDataStream;
import org.jitsi.impl.neomedia.rtp.translator.OutputDataStreamDesc;
import org.jitsi.impl.neomedia.rtp.translator.Payload;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorDesc;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorImpl;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.rtp.translator.StreamRTPManagerDesc;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.util.Logger;

class OutputDataStreamImpl
implements OutputDataStream,
Runnable {
    private static final Logger logger = Logger.getLogger(OutputDataStreamImpl.class);
    private static final String REMOVE_RTP_HEADER_EXTENSIONS_PROPERTY_NAME = RTPTranslatorImpl.class.getName() + ".removeRTPHeaderExtensions";
    private static final int WRITE_QUEUE_CAPACITY = 256;
    private boolean closed;
    private final RTPConnectorImpl connector;
    private final boolean data;
    private final boolean removeRTPHeaderExtensions;
    private final List<OutputDataStreamDesc> streams = new ArrayList<OutputDataStreamDesc>();
    private final RTPTranslatorBuffer[] writeQueue = new RTPTranslatorBuffer[256];
    private int writeQueueHead;
    private int writeQueueLength;
    private Thread writeThread;

    public OutputDataStreamImpl(RTPConnectorImpl connector, boolean data) {
        this.connector = connector;
        this.data = data;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        boolean removeRTPHeaderExtensions = false;
        if (cfg != null) {
            removeRTPHeaderExtensions = cfg.getBoolean(REMOVE_RTP_HEADER_EXTENSIONS_PROPERTY_NAME, removeRTPHeaderExtensions);
        }
        this.removeRTPHeaderExtensions = removeRTPHeaderExtensions;
    }

    public synchronized void addStream(RTPConnectorDesc connectorDesc, OutputDataStream stream) {
        for (OutputDataStreamDesc streamDesc : this.streams) {
            if (streamDesc.connectorDesc != connectorDesc || streamDesc.stream != stream) continue;
            return;
        }
        this.streams.add(new OutputDataStreamDesc(connectorDesc, stream));
    }

    public synchronized void close() {
        this.closed = true;
        this.writeThread = null;
        this.notify();
    }

    private synchronized void createWriteThread() {
        this.writeThread = new Thread((Runnable)this, this.getClass().getName());
        this.writeThread.setDaemon(true);
        this.writeThread.start();
    }

    private synchronized int doWrite(byte[] buffer, int offset, int length, Format format, StreamRTPManagerDesc exclusion) {
        RTPTranslatorImpl translator = this.getTranslator();
        if (translator == null) {
            return 0;
        }
        boolean removeRTPHeaderExtensions = this.removeRTPHeaderExtensions;
        int written = 0;
        int streamCount = this.streams.size();
        for (int streamIndex = 0; streamIndex < streamCount; ++streamIndex) {
            int streamWritten;
            boolean write;
            OutputDataStreamDesc streamDesc = this.streams.get(streamIndex);
            StreamRTPManagerDesc streamRTPManagerDesc = streamDesc.connectorDesc.streamRTPManagerDesc;
            if (streamRTPManagerDesc == exclusion) continue;
            if (this.data) {
                if (removeRTPHeaderExtensions) {
                    removeRTPHeaderExtensions = false;
                    length = this.removeRTPHeaderExtensions(buffer, offset, length);
                }
                write = this.willWriteData(streamRTPManagerDesc, buffer, offset, length, format, exclusion);
            } else {
                write = this.willWriteControl(streamRTPManagerDesc, buffer, offset, length, format, exclusion);
            }
            if (!write || !(write = translator.willWrite(exclusion, buffer, offset, length, streamRTPManagerDesc, this.data)) || written >= (streamWritten = streamDesc.stream.write(buffer, offset, length))) continue;
            written = streamWritten;
        }
        return written;
    }

    private RTPTranslatorImpl getTranslator() {
        return this.connector.translator;
    }

    private int removeRTPHeaderExtensions(byte[] buf, int off, int len) {
        byte b0;
        int v;
        if (len >= 12 && (v = ((b0 = buf[off]) & 0xC0) >>> 6) == 2) {
            int xEnd;
            int end;
            int xLen;
            int cc;
            int xBegin;
            boolean x;
            boolean bl = x = (b0 & 0x10) == 16;
            if (x && (xBegin = off + 12 + 4 * (cc = b0 & 0xF)) + (xLen = 4) < (end = off + len) && (xEnd = xBegin + (xLen += RTPTranslatorImpl.readUnsignedShort(buf, xBegin + 2) * 4)) <= end) {
                int src = xEnd;
                int dst = xBegin;
                while (src < end) {
                    buf[dst++] = buf[src++];
                }
                len -= xLen;
                buf[off] = (byte)(b0 & 0xEF);
            }
        }
        return len;
    }

    public synchronized void removeStreams(RTPConnectorDesc connectorDesc) {
        Iterator<OutputDataStreamDesc> streamIter = this.streams.iterator();
        while (streamIter.hasNext()) {
            OutputDataStreamDesc streamDesc = streamIter.next();
            if (streamDesc.connectorDesc != connectorDesc) continue;
            streamIter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                int length;
                Format format;
                StreamRTPManagerDesc exclusion;
                byte[] buffer;
                RTPTranslatorBuffer write;
                int writeIndex;
                OutputDataStreamImpl outputDataStreamImpl = this;
                synchronized (outputDataStreamImpl) {
                    if (this.closed) return;
                    if (!Thread.currentThread().equals(this.writeThread)) {
                        return;
                    }
                    if (this.writeQueueLength < 1) {
                        boolean interrupted = false;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                        }
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    writeIndex = this.writeQueueHead++;
                    write = this.writeQueue[writeIndex];
                    buffer = write.data;
                    write.data = null;
                    exclusion = write.exclusion;
                    write.exclusion = null;
                    format = write.format;
                    write.format = null;
                    length = write.length;
                    write.length = 0;
                    if (this.writeQueueHead >= this.writeQueue.length) {
                        this.writeQueueHead = 0;
                    }
                    --this.writeQueueLength;
                }
                try {
                    this.doWrite(buffer, 0, length, format, exclusion);
                    outputDataStreamImpl = this;
                }
                catch (Throwable throwable) {
                    OutputDataStreamImpl outputDataStreamImpl2 = this;
                    synchronized (outputDataStreamImpl2) {
                        RTPTranslatorBuffer write2 = this.writeQueue[writeIndex];
                        if (write2 == null) throw throwable;
                        if (write2.data != null) throw throwable;
                        write2.data = buffer;
                        throw throwable;
                    }
                }
                synchronized (outputDataStreamImpl) {
                    write = this.writeQueue[writeIndex];
                    if (write != null && write.data == null) {
                        write.data = buffer;
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error("Failed to translate RTP packet", t);
            if (!(t instanceof ThreadDeath)) return;
            throw (ThreadDeath)t;
        }
        finally {
            OutputDataStreamImpl writeIndex = this;
            synchronized (writeIndex) {
                if (Thread.currentThread().equals(this.writeThread)) {
                    this.writeThread = null;
                }
                if (!this.closed && this.writeThread == null && this.writeQueueLength > 0) {
                    this.createWriteThread();
                }
            }
        }
    }

    private boolean willWriteControl(StreamRTPManagerDesc destination, byte[] buffer, int offset, int length, Format format, StreamRTPManagerDesc exclusion) {
        byte b0;
        int v;
        boolean write = true;
        if (length >= 12 && (v = ((b0 = buffer[offset]) & 0xC0) >>> 6) == 2) {
            int rtcpLength;
            byte b1 = buffer[offset + 1];
            int pt = b1 & 0xFF;
            int fmt = b0 & 0x1F;
            if ((pt == 205 || pt == 206) && (rtcpLength = (RTPTranslatorImpl.readUnsignedShort(buffer, offset + 2) + 1) * 4) <= length) {
                int ssrcOfMediaSource = 0;
                if (pt == 206 && fmt == 4) {
                    if (rtcpLength < 20) {
                        write = false;
                    } else {
                        ssrcOfMediaSource = RTPTranslatorImpl.readInt(buffer, offset + 12);
                    }
                } else {
                    ssrcOfMediaSource = RTPTranslatorImpl.readInt(buffer, offset + 8);
                }
                if (destination.containsReceiveSSRC(ssrcOfMediaSource)) {
                    if (logger.isTraceEnabled()) {
                        int ssrcOfPacketSender = RTPTranslatorImpl.readInt(buffer, offset + 4);
                        String message = this.getClass().getName() + ".willWriteControl: FMT " + fmt + ", PT " + pt + ", SSRC of packet sender " + Long.toString((long)ssrcOfPacketSender & 0xFFFFFFFFL) + ", SSRC of media source " + Long.toString((long)ssrcOfMediaSource & 0xFFFFFFFFL);
                        logger.trace(message);
                    }
                } else {
                    write = false;
                }
            }
        }
        if (write && logger.isTraceEnabled()) {
            RTPTranslatorImpl.logRTCP(this, "doWrite", buffer, offset, length);
        }
        return write;
    }

    private boolean willWriteData(StreamRTPManagerDesc destination, byte[] buffer, int offset, int length, Format format, StreamRTPManagerDesc exclusion) {
        if (!destination.streamRTPManager.getMediaStream().getDirection().allowsSending()) {
            return false;
        }
        if (format != null && length > 0) {
            Integer payloadType = destination.getPayloadType(format);
            if (payloadType == null && exclusion != null) {
                payloadType = exclusion.getPayloadType(format);
            }
            if (payloadType != null) {
                int payloadTypeByteIndex = offset + 1;
                buffer[payloadTypeByteIndex] = (byte)(buffer[payloadTypeByteIndex] & 0x80 | payloadType & 0x7F);
            }
        }
        return true;
    }

    @Override
    public int write(byte[] buffer, int offset, int length) {
        return this.doWrite(buffer, offset, length, null, null);
    }

    public synchronized void write(byte[] buffer, int offset, int length, Format format, StreamRTPManagerDesc exclusion) {
        byte[] data;
        int writeIndex;
        if (this.closed) {
            return;
        }
        if (this.writeQueueLength < this.writeQueue.length) {
            writeIndex = (this.writeQueueHead + this.writeQueueLength) % this.writeQueue.length;
        } else {
            writeIndex = this.writeQueueHead++;
            if (this.writeQueueHead >= this.writeQueue.length) {
                this.writeQueueHead = 0;
            }
            --this.writeQueueLength;
            logger.warn("Will not translate RTP packet.");
        }
        RTPTranslatorBuffer write = this.writeQueue[writeIndex];
        if (write == null) {
            this.writeQueue[writeIndex] = write = new RTPTranslatorBuffer();
        }
        if ((data = write.data) == null || data.length < length) {
            write.data = data = new byte[length];
        }
        System.arraycopy(buffer, offset, data, 0, length);
        write.exclusion = exclusion;
        write.format = format;
        write.length = length;
        ++this.writeQueueLength;
        if (this.writeThread == null) {
            this.createWriteThread();
        } else {
            this.notify();
        }
    }

    synchronized boolean writeControlPayload(Payload controlPayload, MediaStream destination) {
        int streamCount = this.streams.size();
        for (int streamIndex = 0; streamIndex < streamCount; ++streamIndex) {
            OutputDataStreamDesc streamDesc = this.streams.get(streamIndex);
            if (destination != streamDesc.connectorDesc.streamRTPManagerDesc.streamRTPManager.getMediaStream()) continue;
            controlPayload.writeTo(streamDesc.stream);
            return true;
        }
        return false;
    }

    private static class RTPTranslatorBuffer {
        public byte[] data;
        public StreamRTPManagerDesc exclusion;
        public Format format;
        public int length;

        private RTPTranslatorBuffer() {
        }
    }
}

