/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerMediaHandlerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.TransportInfoSender;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriStreamConnector;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.service.protocol.media.TransportManager;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.StreamConnectorFactory;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;

public abstract class TransportManagerJabberImpl
extends TransportManager<CallPeerJabberImpl> {
    private static final Logger logger = Logger.getLogger(TransportManagerJabberImpl.class);
    private static int nextID = 1;
    private ColibriConferenceIQ colibri;
    private int currentGeneration = 0;
    boolean isEstablishingConnectivityWithJitsiVideobridge = false;
    boolean startConnectivityEstablishmentWithJitsiVideobridge = false;

    protected TransportManagerJabberImpl(CallPeerJabberImpl callPeer) {
        super((MediaAwareCallPeer)callPeer);
    }

    protected InetAddress getIntendedDestination(CallPeerJabberImpl peer) {
        return ((ProtocolProviderServiceJabberImpl)peer.getProtocolProvider()).getNextHop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNextID() {
        Class<TransportManagerJabberImpl> clazz = TransportManagerJabberImpl.class;
        synchronized (TransportManagerJabberImpl.class) {
            int nextID = TransportManagerJabberImpl.nextID++;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return Integer.toString(nextID);
        }
    }

    public abstract MediaStreamTarget getStreamTarget(MediaType var1);

    public abstract String getXmlNamespace();

    protected int getCurrentGeneration() {
        return this.currentGeneration;
    }

    protected void incrementGeneration() {
        ++this.currentGeneration;
    }

    protected void sendTransportInfoToJitsiVideobridge(Map<String, IceUdpTransportPacketExtension> map) {
        CallPeerJabberImpl peer = (CallPeerJabberImpl)this.getCallPeer();
        boolean initiator = !peer.isInitiator();
        ColibriConferenceIQ conferenceRequest = null;
        for (Map.Entry<String, IceUdpTransportPacketExtension> e : map.entrySet()) {
            IceUdpTransportPacketExtension transport;
            String media = e.getKey();
            MediaType mediaType = MediaType.parseString((String)media);
            ColibriConferenceIQ.Channel channel = this.getColibriChannel(mediaType, false);
            if (channel == null) continue;
            try {
                transport = TransportManagerJabberImpl.cloneTransportAndCandidates(e.getValue());
            }
            catch (OperationFailedException ofe) {
                transport = null;
            }
            if (transport == null) continue;
            ColibriConferenceIQ.Channel channelRequest = new ColibriConferenceIQ.Channel();
            channelRequest.setID(channel.getID());
            channelRequest.setInitiator(initiator);
            channelRequest.setTransport(transport);
            if (conferenceRequest == null) {
                String id;
                if (this.colibri == null || (id = this.colibri.getID()) == null || id.length() == 0) break;
                conferenceRequest = new ColibriConferenceIQ();
                conferenceRequest.setID(id);
                conferenceRequest.setTo(this.colibri.getFrom());
                conferenceRequest.setType(IQ.Type.SET);
            }
            conferenceRequest.getOrCreateContent(media).addChannel(channelRequest);
        }
        if (conferenceRequest != null) {
            ((ProtocolProviderServiceJabberImpl)peer.getProtocolProvider()).getConnection().sendPacket(conferenceRequest);
        }
    }

    protected abstract PacketExtension startCandidateHarvest(ContentPacketExtension var1, ContentPacketExtension var2, TransportInfoSender var3, String var4) throws OperationFailedException;

    public void startCandidateHarvest(List<ContentPacketExtension> theirOffer, List<ContentPacketExtension> ourAnswer, TransportInfoSender transportInfoSender) throws OperationFailedException {
        List<ContentPacketExtension> cpes;
        CallPeerJabberImpl peer = (CallPeerJabberImpl)this.getCallPeer();
        CallJabberImpl call = (CallJabberImpl)peer.getCall();
        boolean isJitsiVideobridge = call.getConference().isJitsiVideobridge();
        List<ContentPacketExtension> list = cpes = theirOffer == null ? ourAnswer : theirOffer;
        if (isJitsiVideobridge) {
            LinkedHashMap<ContentPacketExtension, ContentPacketExtension> contentMap = new LinkedHashMap<ContentPacketExtension, ContentPacketExtension>();
            for (ContentPacketExtension contentPacketExtension : cpes) {
                ContentPacketExtension remote;
                ContentPacketExtension local;
                MediaType mediaType = JingleUtils.getMediaType(contentPacketExtension);
                if (this.colibri != null && this.colibri.getContent(mediaType.toString()) != null) continue;
                if (cpes == ourAnswer) {
                    local = contentPacketExtension;
                    remote = theirOffer == null ? null : TransportManagerJabberImpl.findContentByName(theirOffer, contentPacketExtension.getName());
                } else {
                    local = TransportManagerJabberImpl.findContentByName(ourAnswer, contentPacketExtension.getName());
                    remote = contentPacketExtension;
                }
                contentMap.put(local, remote);
            }
            if (!contentMap.isEmpty()) {
                if (this.colibri == null) {
                    this.colibri = new ColibriConferenceIQ();
                }
                for (Map.Entry entry : contentMap.entrySet()) {
                    ContentPacketExtension cpe = (ContentPacketExtension)entry.getValue();
                    if (cpe == null) {
                        cpe = (ContentPacketExtension)entry.getKey();
                    }
                    this.colibri.getOrCreateContent(JingleUtils.getMediaType(cpe).toString());
                }
                ColibriConferenceIQ conferenceResult = call.createColibriChannels(peer, contentMap);
                if (conferenceResult != null) {
                    String string = this.colibri.getID();
                    String conferenceResultID = conferenceResult.getID();
                    if (string == null) {
                        this.colibri.setID(conferenceResultID);
                    } else if (!string.equals(conferenceResultID)) {
                        throw new IllegalStateException("conference.id");
                    }
                    String videobridgeFrom = conferenceResult.getFrom();
                    if (videobridgeFrom != null && videobridgeFrom.length() != 0) {
                        this.colibri.setFrom(videobridgeFrom);
                    }
                    for (ColibriConferenceIQ.Content contentResult : conferenceResult.getContents()) {
                        ColibriConferenceIQ.Content content = this.colibri.getOrCreateContent(contentResult.getName());
                        for (ColibriConferenceIQ.Channel channelResult : contentResult.getChannels()) {
                            if (content.getChannel(channelResult.getID()) != null) continue;
                            content.addChannel(channelResult);
                        }
                    }
                } else {
                    ProtocolProviderServiceJabberImpl.throwOperationFailedException("Failed to allocate colibri channel.", 1, null, logger);
                }
            }
        }
        for (ContentPacketExtension cpe : cpes) {
            RtpDescriptionPacketExtension rtpDesc;
            String media;
            ContentPacketExtension theirContent;
            PacketExtension pe;
            String string = cpe.getName();
            ContentPacketExtension ourContent = TransportManagerJabberImpl.findContentByName(ourAnswer, string);
            if (ourContent == null || (pe = this.startCandidateHarvest(theirContent = theirOffer == null ? null : TransportManagerJabberImpl.findContentByName(theirOffer, string), ourContent, transportInfoSender, media = (rtpDesc = ourContent.getFirstChildOfType(RtpDescriptionPacketExtension.class)).getMedia())) == null) continue;
            ourContent.addChildExtension(pe);
        }
    }

    public void startCandidateHarvest(List<ContentPacketExtension> ourOffer, TransportInfoSender transportInfoSender) throws OperationFailedException {
        this.startCandidateHarvest(null, ourOffer, transportInfoSender);
    }

    public abstract List<ContentPacketExtension> wrapupCandidateHarvest();

    public static ContentPacketExtension findContentByName(Iterable<ContentPacketExtension> cpExtList, String name) {
        for (ContentPacketExtension cpExt : cpExtList) {
            if (!cpExt.getName().equals(name)) continue;
            return cpExt;
        }
        return null;
    }

    public boolean startConnectivityEstablishment(Iterable<ContentPacketExtension> remote) {
        return true;
    }

    protected boolean startConnectivityEstablishment(Map<String, IceUdpTransportPacketExtension> remote) {
        return true;
    }

    public void wrapupConnectivityEstablishment() throws OperationFailedException {
    }

    public abstract void removeContent(String var1);

    protected ContentPacketExtension removeContent(Iterable<ContentPacketExtension> contents, String name) {
        Iterator<ContentPacketExtension> contentIter = contents.iterator();
        while (contentIter.hasNext()) {
            ContentPacketExtension content = contentIter.next();
            if (!name.equals(content.getName())) continue;
            contentIter.remove();
            MediaType mediaType = JingleUtils.getMediaType(content);
            if (mediaType != null) {
                this.closeStreamConnector(mediaType);
            }
            return content;
        }
        return null;
    }

    static IceUdpTransportPacketExtension cloneTransportAndCandidates(IceUdpTransportPacketExtension src) throws OperationFailedException {
        try {
            return IceUdpTransportPacketExtension.cloneTransportAndCandidates(src);
        }
        catch (Exception e) {
            ProtocolProviderServiceJabberImpl.throwOperationFailedException("Failed to close transport and candidates.", 1, e, logger);
            return null;
        }
    }

    public void close() {
        for (MediaType mediaType : MediaType.values()) {
            this.closeStreamConnector(mediaType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeStreamConnector(MediaType mediaType, StreamConnector streamConnector) {
        try {
            CallJabberImpl call;
            CallPeerJabberImpl peer;
            boolean superCloseStreamConnector = true;
            if (streamConnector instanceof ColibriStreamConnector && (peer = (CallPeerJabberImpl)this.getCallPeer()) != null && (call = (CallJabberImpl)peer.getCall()) != null) {
                superCloseStreamConnector = false;
                call.closeColibriStreamConnector(peer, mediaType, (ColibriStreamConnector)streamConnector);
            }
            if (superCloseStreamConnector) {
                super.closeStreamConnector(mediaType, streamConnector);
            }
        }
        finally {
            List<ColibriConferenceIQ.Channel> channels;
            ColibriConferenceIQ.Content content;
            if (this.colibri != null && (content = this.colibri.getContent(mediaType.toString())) != null && (channels = content.getChannels()).size() == 2) {
                CallJabberImpl call;
                ColibriConferenceIQ requestConferenceIQ = new ColibriConferenceIQ();
                requestConferenceIQ.setID(this.colibri.getID());
                ColibriConferenceIQ.Content requestContent = requestConferenceIQ.getOrCreateContent(content.getName());
                requestContent.addChannel(channels.get(1));
                this.colibri.removeContent(content);
                CallPeerJabberImpl peer = (CallPeerJabberImpl)this.getCallPeer();
                if (peer != null && (call = (CallJabberImpl)peer.getCall()) != null) {
                    call.expireColibriChannels(peer, requestConferenceIQ);
                }
            }
        }
    }

    protected StreamConnector createStreamConnector(final MediaType mediaType) throws OperationFailedException {
        CallPeerJabberImpl peer;
        CallJabberImpl call;
        ColibriStreamConnector streamConnector;
        ColibriConferenceIQ.Channel channel = this.getColibriChannel(mediaType, true);
        if (channel != null && (streamConnector = (call = (CallJabberImpl)(peer = (CallPeerJabberImpl)this.getCallPeer()).getCall()).createColibriStreamConnector(peer, mediaType, channel, new StreamConnectorFactory(){

            public StreamConnector createStreamConnector() {
                try {
                    return TransportManagerJabberImpl.this.doCreateStreamConnector(mediaType);
                }
                catch (OperationFailedException ofe) {
                    return null;
                }
            }
        })) != null) {
            return streamConnector;
        }
        return this.doCreateStreamConnector(mediaType);
    }

    protected abstract PacketExtension createTransport(String var1) throws OperationFailedException;

    protected PacketExtension createTransportForStartCandidateHarvest(String media) throws OperationFailedException {
        PacketExtension pe = null;
        if (((CallPeerJabberImpl)this.getCallPeer()).isJitsiVideobridge()) {
            MediaType mediaType = MediaType.parseString((String)media);
            ColibriConferenceIQ.Channel channel = this.getColibriChannel(mediaType, false);
            if (channel != null) {
                pe = TransportManagerJabberImpl.cloneTransportAndCandidates(channel.getTransport());
            }
        } else {
            pe = this.createTransport(media);
        }
        return pe;
    }

    protected abstract PacketExtension createTransportPacketExtension();

    protected StreamConnector doCreateStreamConnector(MediaType mediaType) throws OperationFailedException {
        return super.createStreamConnector(mediaType);
    }

    TransportManagerJabberImpl findTransportManagerEstablishingConnectivityWithJitsiVideobridge() {
        CallConference conference;
        MediaAwareCall call = ((CallPeerJabberImpl)this.getCallPeer()).getCall();
        TransportManagerJabberImpl transportManager = null;
        if (call != null && (conference = call.getConference()) != null && conference.isJitsiVideobridge()) {
            block0: for (Call aCall : conference.getCalls()) {
                Iterator callPeerIter = aCall.getCallPeers();
                while (callPeerIter.hasNext()) {
                    CallPeer aCallPeer = (CallPeer)callPeerIter.next();
                    if (!(aCallPeer instanceof CallPeerJabberImpl)) continue;
                    TransportManagerJabberImpl aTransportManager = ((CallPeerMediaHandlerJabberImpl)((CallPeerJabberImpl)aCallPeer).getMediaHandler()).getTransportManager();
                    if (!aTransportManager.isEstablishingConnectivityWithJitsiVideobridge) continue;
                    transportManager = aTransportManager;
                    continue block0;
                }
            }
        }
        return transportManager;
    }

    ColibriConferenceIQ.Channel getColibriChannel(MediaType mediaType, boolean local) {
        List<ColibriConferenceIQ.Channel> channels;
        ColibriConferenceIQ.Content content;
        ColibriConferenceIQ.Channel channel = null;
        if (this.colibri != null && (content = this.colibri.getContent(mediaType.toString())) != null && (channels = content.getChannels()).size() == 2) {
            channel = channels.get(local ? 0 : 1);
        }
        return channel;
    }
}

