/*
 * Decompiled with CFR 0.152.
 */
package nl.goodbytes.xmpp.xep0363;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import nl.goodbytes.xmpp.xep0363.Slot;
import nl.goodbytes.xmpp.xep0363.SlotManager;
import nl.goodbytes.xmpp.xep0363.TooLargeException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.AbstractComponent;
import org.xmpp.packet.IQ;
import org.xmpp.packet.PacketError;

public class Component
extends AbstractComponent {
    public static final String NAMESPACE_EXP = "urn:xmpp:http:upload";
    public static final String NAMESPACE = "urn:xmpp:http:upload:0";
    private static final Logger Log = LoggerFactory.getLogger(Component.class);
    private final String name;
    private final String endpoint;

    public Component(String name, URL endpoint) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Argument 'name' cannot be null or an empty String.");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Argument 'endpoint' cannot be null.");
        }
        this.name = name.trim();
        this.endpoint = endpoint.toExternalForm();
    }

    public String getDescription() {
        return "HTTP File Upload, an implementation of XEP-0363, supporting exchange of files between XMPP entities.";
    }

    public String getName() {
        return this.name;
    }

    protected String discoInfoIdentityCategory() {
        return "store";
    }

    protected String discoInfoIdentityCategoryType() {
        return "file";
    }

    protected String[] discoInfoFeatureNamespaces() {
        return new String[]{NAMESPACE, NAMESPACE_EXP};
    }

    protected IQ handleDiscoInfo(IQ iq) {
        IQ response = super.handleDiscoInfo(iq);
        if (SlotManager.getInstance().getMaxFileSize() > 0L) {
            Element configForm = response.getChildElement().addElement("x", "jabber:x:data");
            configForm.addAttribute("type", "result");
            configForm.addElement("field").addAttribute("var", "FORM_TYPE").addAttribute("type", "hidden").addElement("value").addText(NAMESPACE);
            configForm.addElement("field").addAttribute("var", "max-file-size").addText(Long.toString(SlotManager.getInstance().getMaxFileSize()));
        }
        return response;
    }

    protected IQ handleIQGet(IQ iq) throws Exception {
        Slot slot;
        long fileSize;
        Element request = iq.getChildElement();
        List<String> namespaces = Arrays.asList(NAMESPACE, NAMESPACE_EXP);
        if (!namespaces.contains(request.getNamespaceURI()) || !request.getName().equals("request")) {
            return null;
        }
        Log.info("Entity '{}' tries to obtain slot.", (Object)iq.getFrom());
        String fileName = null;
        if (request.attributeValue("filename") != null && !request.attributeValue("filename").trim().isEmpty()) {
            fileName = request.attributeValue("filename").trim();
        }
        if (request.element("filename") != null && !request.element("filename").getTextTrim().isEmpty()) {
            fileName = request.element("filename").getTextTrim();
        }
        if (fileName == null) {
            IQ response = IQ.createResultIQ((IQ)iq);
            response.setError(PacketError.Condition.bad_request);
            return response;
        }
        String size = null;
        if (request.attributeValue("size") != null && !request.attributeValue("size").isEmpty()) {
            size = request.attributeValue("size").trim();
        }
        if (request.element("size") != null && !request.element("size").getTextTrim().isEmpty()) {
            size = request.element("size").getTextTrim();
        }
        if (size == null) {
            IQ response = IQ.createResultIQ((IQ)iq);
            response.setError(PacketError.Condition.bad_request);
            return response;
        }
        try {
            fileSize = Long.parseLong(request.element("size").getTextTrim());
        }
        catch (NumberFormatException e) {
            IQ response = IQ.createResultIQ((IQ)iq);
            response.setError(PacketError.Condition.bad_request);
            return response;
        }
        SlotManager manager = SlotManager.getInstance();
        try {
            slot = manager.getSlot(iq.getFrom(), fileName, fileSize);
        }
        catch (TooLargeException ex) {
            IQ response = IQ.createResultIQ((IQ)iq);
            PacketError error = new PacketError(PacketError.Condition.not_acceptable, PacketError.Type.modify, "File too large. Maximum file size is " + ex.getMaximum() + " bytes.");
            error.getElement().addElement("file-too-large", iq.getChildElement().getNamespaceURI()).addElement("max-file-size").addText(Long.toString(ex.getMaximum()));
            response.setError(error);
            return response;
        }
        URL url = new URL(this.endpoint + "/" + slot.getUuid() + "/" + fileName);
        Log.info("Entity '{}' obtained slot for '{}' ({} bytes): {}", new Object[]{iq.getFrom(), fileName, fileSize, url.toExternalForm()});
        IQ response = IQ.createResultIQ((IQ)iq);
        Element slotElement = response.setChildElement("slot", iq.getChildElement().getNamespaceURI());
        slotElement.addElement("put").setText(url.toExternalForm());
        slotElement.addElement("get").setText(url.toExternalForm());
        return response;
    }
}

