/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.MultiValueMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiValueMapImpl<V>
implements MultiValueMap<String, V>,
Cloneable {
    private HashMap<String, ArrayList<V>> map = null;
    private static final long serialVersionUID = 4275505380960964605L;

    @Override
    public List<V> put(String key, V value) {
        ArrayList<Object> keyList = null;
        if (this.map != null) {
            keyList = this.map.get(key);
        }
        if (keyList == null) {
            keyList = new ArrayList();
            this.getMap().put(key, keyList);
        }
        keyList.add(value);
        return keyList;
    }

    @Override
    public boolean containsValue(Object value) {
        Set<Map.Entry<String, ArrayList<V>>> pairs = null;
        if (this.map != null) {
            pairs = this.map.entrySet();
        }
        if (pairs == null) {
            return false;
        }
        for (Map.Entry<String, ArrayList<V>> keyValuePair : pairs) {
            ArrayList<V> list = keyValuePair.getValue();
            if (!list.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.map != null) {
            Set<Map.Entry<String, ArrayList<V>>> pairs = this.map.entrySet();
            for (Map.Entry<String, ArrayList<V>> keyValuePair : pairs) {
                ArrayList<V> list = keyValuePair.getValue();
                list.clear();
            }
            this.map.clear();
        }
    }

    @Override
    public Collection values() {
        if (this.map == null) {
            return new ArrayList();
        }
        ArrayList<Object> returnList = new ArrayList<Object>(this.map.size());
        Set<Map.Entry<String, ArrayList<V>>> pairs = this.map.entrySet();
        for (Map.Entry<String, ArrayList<V>> keyValuePair : pairs) {
            ArrayList<V> list = keyValuePair.getValue();
            Object[] values = list.toArray();
            for (int ii = 0; ii < values.length; ++ii) {
                returnList.add(values[ii]);
            }
        }
        return returnList;
    }

    public Object clone() {
        MultiValueMapImpl<V> obj = new MultiValueMapImpl<V>();
        if (this.map != null) {
            obj.map = (HashMap)this.map.clone();
        }
        return obj;
    }

    @Override
    public int size() {
        if (this.map == null) {
            return 0;
        }
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(key);
    }

    @Override
    public Set entrySet() {
        if (this.map == null) {
            return new HashSet();
        }
        return this.map.entrySet();
    }

    @Override
    public boolean isEmpty() {
        if (this.map == null) {
            return true;
        }
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        if (this.map == null) {
            return new HashSet<String>();
        }
        return this.map.keySet();
    }

    @Override
    public Object remove(String key, V item) {
        if (this.map == null) {
            return null;
        }
        ArrayList<V> list = this.map.get(key);
        if (list == null) {
            return null;
        }
        return list.remove(item);
    }

    @Override
    public List<V> get(Object key) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(key);
    }

    @Override
    public List<V> put(String key, List<V> value) {
        return this.getMap().put(key, (ArrayList)value);
    }

    @Override
    public List<V> remove(Object key) {
        if (this.map == null) {
            return null;
        }
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<V>> mapToPut) {
        for (String string : mapToPut.keySet()) {
            ArrayList al = new ArrayList();
            al.addAll(mapToPut.get(string));
            this.getMap().put(string, al);
        }
    }

    public HashMap<String, ArrayList<V>> getMap() {
        if (this.map == null) {
            this.map = new HashMap(0);
        }
        return this.map;
    }
}

