/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.ClientPortableHook;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.client.ClientMembershipEvent;
import com.hazelcast.cluster.client.MemberAttributeChange;
import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.SerializableCollection;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;

public final class AddMembershipListenerRequest
extends CallableClientRequest
implements RetryableRequest {
    public Object call() throws Exception {
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        ClientEndpoint endpoint = this.getEndpoint();
        String registrationId = service.addMembershipListener(new MembershipListenerImpl(endpoint));
        String name = "hz:core:clusterService";
        endpoint.setListenerRegistration(name, name, registrationId);
        Collection<MemberImpl> memberList = service.getMemberList();
        ArrayList<Data> response = new ArrayList<Data>(memberList.size());
        for (MemberImpl member : memberList) {
            response.add((Data)this.serializationService.toData(member));
        }
        return new SerializableCollection(response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:clusterService";
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    private class MembershipListenerImpl
    implements MembershipListener {
        private final ClientEndpoint endpoint;

        public MembershipListenerImpl(ClientEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public void memberAdded(MembershipEvent membershipEvent) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            MemberImpl member = (MemberImpl)membershipEvent.getMember();
            ClientMembershipEvent event = new ClientMembershipEvent((Member)member, 1);
            this.endpoint.sendEvent(null, event, AddMembershipListenerRequest.this.getCallId());
        }

        @Override
        public void memberRemoved(MembershipEvent membershipEvent) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            MemberImpl member = (MemberImpl)membershipEvent.getMember();
            ClientMembershipEvent event = new ClientMembershipEvent((Member)member, 2);
            this.endpoint.sendEvent(null, event, AddMembershipListenerRequest.this.getCallId());
        }

        @Override
        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            MemberImpl member = (MemberImpl)memberAttributeEvent.getMember();
            String uuid = member.getUuid();
            MemberAttributeOperationType op = memberAttributeEvent.getOperationType();
            String key = memberAttributeEvent.getKey();
            Object value = memberAttributeEvent.getValue();
            MemberAttributeChange memberAttributeChange = new MemberAttributeChange(uuid, op, key, value);
            ClientMembershipEvent event = new ClientMembershipEvent((Member)member, memberAttributeChange);
            this.endpoint.sendEvent(null, event, AddMembershipListenerRequest.this.getCallId());
        }
    }
}

