/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.cluster.impl.BindMessage;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.tcp.PacketReader;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import java.nio.ByteBuffer;

public class DefaultPacketReader
implements PacketReader {
    protected final TcpIpConnection connection;
    protected final IOService ioService;
    protected Packet packet;

    public DefaultPacketReader(TcpIpConnection connection, IOService ioService) {
        this.connection = connection;
        this.ioService = ioService;
    }

    @Override
    public void readPacket(ByteBuffer inBuffer) throws Exception {
        while (inBuffer.hasRemaining()) {
            boolean complete;
            if (this.packet == null) {
                this.packet = this.obtainPacket();
            }
            if (!(complete = this.packet.readFrom(inBuffer))) break;
            this.handlePacket(this.packet);
            this.packet = null;
        }
    }

    protected void handlePacket(Packet packet) {
        packet.setConn(this.connection);
        if (packet.isHeaderSet(5)) {
            this.handleBind(packet);
        } else {
            this.ioService.handleMemberPacket(packet);
        }
    }

    protected void handleBind(Packet packet) {
        TcpIpConnectionManager connectionManager = this.connection.getConnectionManager();
        BindMessage bind = (BindMessage)this.ioService.toObject(packet.getData());
        connectionManager.bind(this.connection, bind.getLocalAddress(), bind.getTargetAddress(), bind.shouldReply());
    }

    protected Packet obtainPacket() {
        return new Packet();
    }
}

