/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.unix;

import cx.ath.matthew.unix.UnixSocket;
import cx.ath.matthew.unix.UnixSocketAddress;
import java.io.IOException;

public class UnixServerSocket {
    private UnixSocketAddress address = null;
    private boolean bound = false;
    private boolean closed = false;
    private int sock;

    private native int native_bind(String var1, boolean var2) throws IOException;

    private native void native_close(int var1) throws IOException;

    private native int native_accept(int var1) throws IOException;

    public UnixServerSocket() {
    }

    public UnixServerSocket(UnixSocketAddress unixSocketAddress) throws IOException {
        this.bind(unixSocketAddress);
    }

    public UnixServerSocket(String string) throws IOException {
        this(new UnixSocketAddress(string));
    }

    public UnixSocket accept() throws IOException {
        int n = this.native_accept(this.sock);
        return new UnixSocket(n, this.address);
    }

    public synchronized void close() throws IOException {
        this.native_close(this.sock);
        this.sock = 0;
        this.closed = true;
        this.bound = false;
    }

    public void bind(UnixSocketAddress unixSocketAddress) throws IOException {
        if (this.bound) {
            this.close();
        }
        this.sock = this.native_bind(unixSocketAddress.path, unixSocketAddress.abs);
        this.bound = true;
        this.closed = false;
        this.address = unixSocketAddress;
    }

    public void bind(String string) throws IOException {
        this.bind(new UnixSocketAddress(string));
    }

    public UnixSocketAddress getAddress() {
        return this.address;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isBound() {
        return this.bound;
    }

    static {
        System.loadLibrary("unix-java");
    }
}

